/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.notification;

import com.adobe.cq.social.commons.notification.Subscribable;
import com.day.cq.security.Authorizable;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.HashMap;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscribable
implements Subscribable {
    private final WorkflowService workflowService;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSubscribable.class);

    protected AbstractSubscribable(WorkflowService service) {
        this.workflowService = service;
    }

    protected Workflow startWorkflow(Authorizable authorizable, String workflowModel, Session session, String dataPath) throws WorkflowException {
        if (null == authorizable) {
            throw new IllegalArgumentException("authorizable may not be null");
        }
        WorkflowSession wfSession = this.workflowService.getWorkflowSession(session);
        try {
            WorkflowModel model = wfSession.getModel(workflowModel);
            if (null != model) {
                WorkflowData data = wfSession.newWorkflowData("JCR_PATH", dataPath);
                HashMap<String, Object> metaData = new HashMap<String, Object>();
                metaData.put("socialstateToggleUser", authorizable.getHomePath());
                Workflow result = wfSession.startWorkflow(model, data, metaData);
                LOG.info("Started subscription workflow [{}] for user [{}] for [{}].", new Object[]{workflowModel, authorizable.getID(), dataPath});
                return result;
            }
            LOG.error("unable to un-/subscribe user [{}] to topic [{}], workflow model [" + workflowModel + "] not found.", (Object)authorizable.getID(), (Object)dataPath);
            throw new WorkflowException("configured subscribe workflow model not found: " + workflowModel);
        }
        catch (WorkflowException e) {
            LOG.error("unable to un-/subscribe user [{}] to topic [" + dataPath + "]: {}", (Object)authorizable.getID(), (Object)e);
            throw e;
        }
    }
}

