/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.security;

import com.adobe.cq.social.commons.AttachmentTypeBlacklistService;
import com.adobe.cq.social.commons.SaferSlingPostValidator;
import com.adobe.cq.social.ugcbase.AttachmentDataSource;
import com.day.text.Text;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.osgi.service.component.ComponentContext;

@Component(label="AEM Social Communities SaferSlingPostValidator", metatype=true)
@Service(serviceFactory=true, value={SaferSlingPostValidator.class})
@Properties(value={@Property(name="service.description", value={"Safer Sling Post Validator"}, propertyPrivate=true)})
public class SaferSlingPostValidatorImpl
implements SaferSlingPostValidator {
    private static final String OPERATION_PARAMETER = ":operation";
    private static final String TYPEHINT_SUFFIX = "@TypeHint";
    private static final String RESOURCETYPE_PARAMETER = "sling:resourceType";
    private static final String RESOURCESUPERTYPE_PARAMETER = "sling:resourceSuperType";
    private static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    private static final String JCR_MIXINTYPES = "jcr:mixinTypes";
    private static final String BINARY = "Binary";
    @Property(value={"jcr:description", "jcr:title", "jcr:lastModified", "jcr:primaryType", "jcr:mixinTypes", "sling:resourceType", "sling:resourceSuperType", "cq:tags"})
    private static final String PARAMETER_WHITELIST = "parameter.whitelist";
    @Property(value={"social:"}, cardinality=0x7FFFFFFF)
    private static final String PARAMETER_WHITELIST_PREFIXES = "parameter.whitelist.prefixes";
    @Property(value={}, cardinality=0x7FFFFFFF)
    private static final String BINARY_PARAMETER_WHITELIST = "binary.parameter.whitelist";
    @Property(value={"@TypeHint", "@DefaultValue", "@UseDefaultWhenMissing", "@IgnoreBlanks", "@ValueFrom", "@Delete", "@Patch"})
    private static final String MODIFIER_WHITELIST = "modifier.whitelist";
    @Property(value={"delete", "nop"})
    private static final String OPERATION_WHITELIST = "operation.whitelist";
    @Property(value={"social:"}, cardinality=0x7FFFFFFF)
    private static final String OPERATION_WHITELIST_PREFIXES = "operation.whitelist.prefixes";
    @Property(value={"cq:CalendarEvent", "nt:unstructured", "nt:folder", "nt:file", "nt:resource", "sling:Folder", "sling:OrderedFolder", "Binary", "Boolean", "Date", "Double", "Long", "Name", "Path", "String"})
    private static final String TYPEHINT_WHITELIST = "typehint.whitelist";
    @Property(value={"social/calendar/components/event"}, cardinality=0x7FFFFFFF)
    private static final String RESOURCETYPE_WHITELIST = "resourcetype.whitelist";
    @Reference
    private AttachmentTypeBlacklistService attachmentTypeBlacklist;
    private Set<String> parameterWhiteList = new HashSet<String>();
    private Set<String> parameterWhiteListPrefixes = new HashSet<String>();
    private Set<String> binaryParameterWhiteList = new HashSet<String>();
    private Set<String> modifierWhiteList = new HashSet<String>();
    private Set<String> operationWhiteList = new HashSet<String>();
    private Set<String> operationWhiteListPrefixes = new HashSet<String>();
    private Set<String> typeHintWhiteList = new HashSet<String>();
    private Set<String> resourceTypeWhiteList = new HashSet<String>();

    @Activate
    protected void activate(ComponentContext ctx) {
        Object o = ctx.getProperties().get(PARAMETER_WHITELIST);
        if (o instanceof String[]) {
            this.parameterWhiteList = new HashSet<String>();
            this.parameterWhiteList.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(PARAMETER_WHITELIST_PREFIXES)) instanceof String[]) {
            this.parameterWhiteListPrefixes = new HashSet<String>();
            this.parameterWhiteListPrefixes.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(BINARY_PARAMETER_WHITELIST)) instanceof String[]) {
            this.binaryParameterWhiteList = new HashSet<String>();
            this.binaryParameterWhiteList.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(MODIFIER_WHITELIST)) instanceof String[]) {
            this.modifierWhiteList = new HashSet<String>();
            this.modifierWhiteList.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(OPERATION_WHITELIST)) instanceof String[]) {
            this.operationWhiteList = new HashSet<String>();
            this.operationWhiteList.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(OPERATION_WHITELIST_PREFIXES)) instanceof String[]) {
            this.operationWhiteListPrefixes = new HashSet<String>();
            this.operationWhiteListPrefixes.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(TYPEHINT_WHITELIST)) instanceof String[]) {
            this.typeHintWhiteList = new HashSet<String>();
            this.typeHintWhiteList.addAll(Arrays.asList((String[])o));
        }
        if ((o = ctx.getProperties().get(RESOURCETYPE_WHITELIST)) instanceof String[]) {
            this.resourceTypeWhiteList = new HashSet<String>();
            this.resourceTypeWhiteList.addAll(Arrays.asList((String[])o));
        }
    }

    @Override
    public boolean reject(SlingHttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name;
            Object o = paramNames.nextElement();
            if (!(o instanceof String)) {
                return true;
            }
            String fullName = (String)o;
            if (fullName.startsWith("../") || fullName.endsWith("/..") || fullName.contains("/../") || fullName.startsWith("/")) {
                return true;
            }
            String prename = this.leafName(fullName);
            int atidx = prename.lastIndexOf(64);
            if (atidx >= 0) {
                String modifier = prename.substring(atidx);
                name = prename.substring(0, atidx);
                if (this.checkModifier(request, name, fullName, modifier)) {
                    return true;
                }
            } else {
                name = prename;
            }
            if (OPERATION_PARAMETER.equals(name) && this.checkOperation(request, name, fullName)) {
                return true;
            }
            if ((JCR_PRIMARYTYPE.equals(name) || JCR_MIXINTYPES.equals(name)) && this.checkJCRTypes(request, name, fullName)) {
                return true;
            }
            if ((RESOURCETYPE_PARAMETER.equals(name) || RESOURCESUPERTYPE_PARAMETER.equals(name)) && this.checkResourceTypes(request, name, fullName)) {
                return true;
            }
            if (name.contains(":") && !name.startsWith(":") && !this.parameterWhiteList.contains(name) && this.checkParameterPrefixes(name)) {
                return true;
            }
            if (":applyTo".equals(name) && this.validateApplyTo(request)) {
                return true;
            }
            if (!this.validateUploads(request, name)) continue;
            return true;
        }
        return false;
    }

    private boolean checkParameterPrefixes(String name) {
        for (String prefix : this.parameterWhiteListPrefixes) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    private String leafName(String name) {
        int slashidx = name.lastIndexOf(47);
        if (slashidx >= 0) {
            return name.substring(slashidx + 1);
        }
        return name;
    }

    private boolean checkResourceTypes(SlingHttpServletRequest request, String name, String fullName) {
        String[] values = request.getParameterValues(fullName);
        if (values != null) {
            if (values.length > 1) {
                return true;
            }
            return !this.resourceTypeWhiteList.contains(values[0]);
        }
        return true;
    }

    private boolean checkJCRTypes(SlingHttpServletRequest request, String name, String fullName) {
        String[] values = request.getParameterValues(fullName);
        if (values != null) {
            for (String type : values) {
                if (this.typeHintWhiteList.contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkOperation(SlingHttpServletRequest request, String name, String fullName) {
        String[] values = request.getParameterValues(fullName);
        if (values != null) {
            if (values.length > 1) {
                return true;
            }
            if (!"".equals(values[0]) && !this.operationWhiteList.contains(values[0])) {
                for (String prefix : this.operationWhiteListPrefixes) {
                    if (!values[0].startsWith(prefix)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkModifier(SlingHttpServletRequest request, String name, String fullName, String modifier) {
        if (!"".equals(modifier) && !this.modifierWhiteList.contains(modifier)) {
            return true;
        }
        return this.checkTypeHint(request, name, fullName, modifier);
    }

    private boolean checkTypeHint(SlingHttpServletRequest request, String name, String fullName, String modifier) {
        String[] values;
        if (TYPEHINT_SUFFIX.equals(modifier) && (values = request.getParameterValues(fullName)) != null) {
            if (values.length > 1) {
                return true;
            }
            String type = values[0];
            if (!"".equals(type) && !this.typeHintWhiteList.contains(type)) {
                return true;
            }
            if (BINARY.equals(type) && name.contains(".") && !this.binaryParameterWhiteList.contains(name)) {
                return true;
            }
        }
        return false;
    }

    private boolean validateApplyTo(SlingHttpServletRequest request) {
        String[] paths = request.getParameterValues(":applyTo");
        if (paths == null) {
            return false;
        }
        Integer depth = (Integer)request.getAttribute(SaferSlingPostValidator.POST_DEPTH_ATTRIBUTE);
        for (String path : paths) {
            if (path == null || !this.validateApplyToPath(path, request.getResource().getPath(), depth != null ? depth : 0)) continue;
            return true;
        }
        return false;
    }

    private boolean validateApplyToPath(String applyToPath, String resourcePath, int depth) {
        String canonPath = Text.makeCanonicalPath(applyToPath);
        if (!canonPath.startsWith(resourcePath)) {
            return true;
        }
        String testPath = canonPath.substring(resourcePath.length());
        if (testPath.length() > 0 && testPath.charAt(0) == '/') {
            testPath = testPath.substring(1);
        }
        if (testPath.length() == 0) {
            return false;
        }
        int testDepth = testPath.split("/").length;
        return testDepth > depth;
    }

    private boolean validateUploads(SlingHttpServletRequest request, String name) {
        RequestParameter[] rps = request.getRequestParameters(name);
        if (rps == null) {
            return false;
        }
        for (RequestParameter rp : rps) {
            AttachmentDataSource ads;
            if (rp.isFormField() || !this.attachmentTypeBlacklist.reject(ads = new AttachmentDataSource(rp))) continue;
            return true;
        }
        return false;
    }

    protected void bindAttachmentTypeBlacklist(AttachmentTypeBlacklistService attachmentTypeBlacklistService) {
        this.attachmentTypeBlacklist = attachmentTypeBlacklistService;
    }

    protected void unbindAttachmentTypeBlacklist(AttachmentTypeBlacklistService attachmentTypeBlacklistService) {
        if (this.attachmentTypeBlacklist == attachmentTypeBlacklistService) {
            this.attachmentTypeBlacklist = null;
        }
    }
}

