/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.api;

import com.adobe.cq.social.commons.events.SocialEvent;
import com.adobe.cq.social.forum.api.Post;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;

public final class ForumEvent
extends SocialEvent<Type>
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String PROP_EVENT_TYPE = "EventType";
    private static final String PROP_EVENT_PATH = "EventPath";
    private static final String PROP_FORUM_PATH = "ForumPath";
    private static final String FORUM_TOPIC = "forum";
    public static final String EVENT_TOPIC = "com/adobe/cq/social/forum";
    @Deprecated
    public static final String COLLAB_EVENT_TOPIC = "com/day/cq/collab/forum";
    protected static final String PROP_TOPIC_PATH = "TopicPath";

    @Deprecated
    public ForumEvent(Dictionary<String, Object> properties) {
        super(FORUM_TOPIC, (String)properties.get(PROP_EVENT_PATH), (String)properties.get("userId"), (Type)properties.get(PROP_EVENT_TYPE), ForumEvent.getPropertiesMap(properties));
    }

    private static Map<String, Object> getPropertiesMap(Dictionary<String, Object> properties) {
        HashMap<String, Object> additionalProps = new HashMap<String, Object>(properties.size());
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (PROP_EVENT_PATH.equals(key) || PROP_EVENT_TYPE.equals(key) || "userId".equals(key)) continue;
            additionalProps.put(key, properties.get(key));
        }
        return additionalProps;
    }

    public ForumEvent(Type type, Post post) {
        super(FORUM_TOPIC, post.getPath(), post.getCreatedBy().getUserID(), type, post.isTopic() ? ForumEvent.buildTopicProperties(post) : ForumEvent.buildPostProperties(post));
    }

    private static Map<String, Object> buildPostProperties(final Post post) {
        return new HashMap<String, Object>(4){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(ForumEvent.PROP_FORUM_PATH, post.getForum().getPath());
                this.put(ForumEvent.PROP_TOPIC_PATH, post.getTopic().getPath());
            }
        };
    }

    private static Map<String, Object> buildTopicProperties(final Post post) {
        return new HashMap<String, Object>(4){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(ForumEvent.PROP_FORUM_PATH, post.getForum().getPath());
                this.put(ForumEvent.PROP_TOPIC_PATH, post.getPath());
            }
        };
    }

    private ForumEvent(Event event) {
        super(event);
    }

    public ForumEvent(String postPath, String forumPath, String topicPath, String id, Type type) {
        super(FORUM_TOPIC, postPath, id, type, ForumEvent.buildPathMap(forumPath, topicPath));
    }

    private static Map<String, Object> buildPathMap(final String forumPath, final String topicPath) {
        return new HashMap<String, Object>(2){
            private static final long serialVersionUID = 1L;
            {
                super(x0);
                this.put(ForumEvent.PROP_FORUM_PATH, forumPath);
                this.put(ForumEvent.PROP_TOPIC_PATH, topicPath);
            }
        };
    }

    public String getForumPath() {
        return (String)this.getProperty(PROP_FORUM_PATH);
    }

    public String getTopicPath() {
        return (String)this.getProperty(PROP_TOPIC_PATH);
    }

    @Deprecated
    public Type getType() {
        return (Type)this.getAction();
    }

    @Deprecated
    public Event toEvent() {
        return this;
    }

    public static ForumEvent fromEvent(Event event) {
        if (!event.getTopic().equals(EVENT_TOPIC) && !event.getTopic().equals(COLLAB_EVENT_TOPIC)) {
            return null;
        }
        return new ForumEvent(event);
    }

    public String toString() {
        return "ForumEvent:(path=" + this.getPath() + ",type=" + this.getType().toString() + ",forumPath=" + this.getForumPath() + ")";
    }

    public static enum Type implements SocialEvent.SocialActions
    {
        TopicAdded,
        PostAdded,
        PostApproved,
        TopicEdited,
        PostEdited,
        TopicDeleted,
        PostDeleted;

    }
}

