/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.client.api.BaseQueryRequestInfo;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.DefaultResourceID;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.ResourceID;
import com.adobe.cq.social.commons.client.api.User;
import com.adobe.cq.social.commons.comments.api.AbstractComment;
import com.adobe.cq.social.commons.comments.listing.CommentIndexElementFactory;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.forum.client.api.AbstractForumConfiguration;
import com.adobe.cq.social.forum.client.api.ForumConfiguration;
import com.adobe.cq.social.forum.client.api.Post;
import com.adobe.cq.social.forum.client.impl.ForumUtils;
import com.adobe.cq.social.forum.client.impl.PostImpl;
import com.adobe.cq.social.forum.client.listing.impl.PostIndexElementFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPost<T extends ForumConfiguration>
extends AbstractComment<T>
implements Post<T> {
    private static final String TOPIC_HTML_SUFFIX = ".topic.html";
    private Resource latestPost;
    private final Resource parent;
    private int numReplies;
    private ValueMap properties;
    private boolean isTopic;
    private final int numParticipants = -1;
    private User lastModifiedUser;
    private CommentSocialComponentListProviderManager listProviderManager;
    private static final Logger LOG = LoggerFactory.getLogger(PostImpl.class);

    public AbstractPost(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractPost(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.properties = ResourceUtil.getValueMap(resource);
        this.isTopic = this.isTopLevel();
        this.parent = ForumUtils.getParent((Resource)resource, (boolean)this.isTopic, (boolean)false);
        this.listProviderManager = listProviderManager;
    }

    public AbstractPost(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, Resource latestPost, int numReplies, CommentSocialComponentListProviderManager listProviderManager) throws RepositoryException {
        this(resource, clientUtils, queryInfo, listProviderManager);
        this.latestPost = latestPost;
        this.numReplies = numReplies;
        this.listProviderManager = listProviderManager;
    }

    @Override
    public String getSubject() {
        String subject = (String)((Object)this.properties.get("jcr:title", String.class));
        if (this.isTopic) {
            return subject;
        }
        if (StringUtils.isEmpty((String)subject)) {
            ValueMap props = ResourceUtil.getValueMap(this.parent);
            return (String)((Object)this.properties.get("jcr:title", String.class));
        }
        return subject;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public User getLastModifiedUser() {
        if (this.lastModifiedUser == null) {
            String userId = null;
            if (this.latestPost != null) {
                try {
                    PostImpl lpost = new PostImpl(this.latestPost, this.clientUtils, this.getQueryRequestInfo(), this.listProviderManager);
                    userId = lpost.getAuthor().getUserId();
                }
                catch (RepositoryException e) {
                    LOG.error("error getting latest post.", (Throwable)e);
                }
            }
            if (userId == null) {
                userId = super.getAuthor().getUserId();
            }
            this.lastModifiedUser = this.clientUtils.getUser(userId, this.resource.getResourceResolver());
        }
        return this.lastModifiedUser;
    }

    @Override
    public boolean isPinned() {
        return this.properties.get("pinned", false);
    }

    @Override
    public boolean isClosed() {
        return this.isForumClosed() || this.isTopicClosed();
    }

    @Override
    public boolean isTopicClosed() {
        return super.isClosed();
    }

    @Override
    public boolean isForumClosed() {
        return this.properties.get("closed", false);
    }

    @Override
    public boolean isTopic() {
        return this.isTopic;
    }

    @Override
    public String getForumId() {
        return this.getParentId();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLatestPost() {
        return this.latestPost == null ? null : this.latestPost.getPath();
    }

    @Override
    protected CommentIndexElementFactory getIndexElementFactory() {
        QueryRequestInfo queryInfo = this.getQueryRequestInfo();
        BaseQueryRequestInfo nextLevelQueryInfo = new BaseQueryRequestInfo(queryInfo.isQuery(), queryInfo.getPredicates(), CollectionPagination.EMBEDDED_LEVEL_PAGINATION);
        return new PostIndexElementFactory(this.clientUtils, (QueryRequestInfo)nextLevelQueryInfo);
    }

    @Override
    public void setLatestPost(Resource post) {
        this.latestPost = post;
    }

    @Override
    public void setNumReplies(int replies) {
        this.numReplies = replies;
    }

    @Override
    public String getFriendlyUrl() {
        String pagePath = this.clientUtils.getSocialUtils().getContainingPage(this.parent).getPath();
        ResourceID urlid = this.id;
        if (!this.isTopic) {
            Resource topicResource = ForumUtils.getParent((Resource)this.getResource(), (boolean)this.isTopic, (boolean)true);
            urlid = new DefaultResourceID(topicResource);
        }
        return this.clientUtils.externalLink(pagePath, false) + TOPIC_HTML_SUFFIX + urlid + ".html";
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        super.setPagination(pagination);
    }

    @Override
    public T createConfiguration(Resource resource, CommentSystem cs) {
        return (T)new AbstractForumConfiguration(resource, cs);
    }
}

