/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.DateUtilHelper;
import com.adobe.cq.social.handlebars.I18nHelper;
import com.adobe.cq.social.handlebars.IncludeClientLibraryHelper;
import com.adobe.cq.social.handlebars.IncludeHelper;
import com.adobe.cq.social.handlebars.LoadMoreHelper;
import com.adobe.cq.social.handlebars.PageInfoHelper;
import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.widget.HtmlLibraryManager;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

public class DefaultHelpersRegister {
    private final XSSAPI xssAPI;
    private final TemplateContextProviderService contextProviderService;
    private final HtmlLibraryManager htmlLibraryManager;

    public DefaultHelpersRegister(XSSAPI xssAPI, TemplateContextProviderService contextProviderService, HtmlLibraryManager htmlLibraryManager) {
        this.xssAPI = xssAPI;
        this.contextProviderService = contextProviderService;
        this.htmlLibraryManager = htmlLibraryManager;
    }

    public void registerStaticHelpers(Handlebars handlebars, ResourceResolver adminResolver) throws NoSuchMethodException {
        handlebars.registerHelper("pages", (Helper)new PageInfoHelper());
        handlebars.registerHelper("loadmore", (Helper)new LoadMoreHelper());
        handlebars.registerHelper("i18n", (Helper)new I18nHelper());
        handlebars.registerHelper("include", (Helper)new IncludeHelper(adminResolver, this.contextProviderService));
        handlebars.registerHelper("dateUtil", (Helper)new DateUtilHelper());
        handlebars.registerHelper("includeClientLib", (Helper)new IncludeClientLibraryHelper(this.htmlLibraryManager));
        handlebars.registerHelper("encodeForHTMLAttr", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.encodeForHTMLAttr(context);
            }
        });
        handlebars.registerHelper("filterHTML", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                String htmlString = context.replaceAll("\\r", "");
                htmlString = context.replaceAll("\\n", "<br>");
                return DefaultHelpersRegister.this.xssAPI.filterHTML(htmlString);
            }
        });
        handlebars.registerHelper("encodeURI", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return new Handlebars.SafeString((CharSequence)URIUtil.encodePath((String)context.toString()));
            }
        });
        handlebars.registerHelper("equals", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                if (context.equalsIgnoreCase((String)options.param(0))) {
                    return options.fn();
                }
                return options.inverse();
            }
        });
        handlebars.registerHelper("encodeForJSString", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.encodeForJSString(context);
            }
        });
        handlebars.registerHelper("lastPath", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                return StringUtils.substringAfterLast((String)context, (String)"/");
            }
        });
        handlebars.registerHelper("xss-htmlAttr", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.encodeForHTMLAttr(context.toString());
            }
        });
        handlebars.registerHelper("xss-jsString", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.encodeForJSString(context.toString());
            }
        });
        handlebars.registerHelper("xss-html", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.encodeForHTML(context.toString());
            }
        });
        handlebars.registerHelper("xss-validHref", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                return DefaultHelpersRegister.this.xssAPI.getValidHref(context.toString());
            }
        });
        handlebars.registerHelper("dom-id", (Helper)new Helper<Object>(){

            public CharSequence apply(Object context, Options options) throws IOException {
                String ctx = context.toString();
                String temp = ctx.replaceAll("\\.", "-");
                temp = temp.replaceAll("/", "-");
                temp = temp.replaceAll(":", "-");
                return new Handlebars.SafeString((CharSequence)temp);
            }
        });
        handlebars.registerHelper("pretty-time", (Helper)new Helper<Long>(){

            public CharSequence apply(Long context, Options options) throws IOException {
                Date time = new Date(context);
                long diff = Calendar.getInstance().getTime().getTime() - time.getTime();
                int second = 1000;
                int minute = 60000;
                int hour = 3600000;
                int day = 86400000;
                if (diff < 60000L) {
                    long t = Math.round(diff / 1000L);
                    if (t == 1L) {
                        return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " second ago"));
                    }
                    return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " seconds ago"));
                }
                if (diff < 3600000L) {
                    long t = Math.round(diff / 60000L);
                    if (t == 1L) {
                        return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " minute ago"));
                    }
                    return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " minutes ago"));
                }
                if (diff < 86400000L) {
                    long t = Math.round(diff / 3600000L);
                    if (t == 1L) {
                        return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " hour ago"));
                    }
                    return new Handlebars.SafeString((CharSequence)(Long.toString(t) + " hours ago"));
                }
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy, h:mm a");
                return new Handlebars.SafeString((CharSequence)formatter.format(time));
            }
        });
        handlebars.registerHelper("abbreviate", (Helper)new Helper<String>(){

            public CharSequence apply(String context, Options options) throws IOException {
                String ctx = context.toString();
                if (StringUtils.isEmpty((CharSequence)ctx)) {
                    return "";
                }
                int maxLength = (Integer)options.hash("maxLength", (Object)256);
                int maxWords = (Integer)options.hash("maxWords", (Object)30);
                boolean safeString = (Boolean)options.hash("safeString", (Object)false);
                ctx = ctx.substring(0, (ctx = ctx.trim()).length() > maxLength ? maxLength : ctx.length());
                Object[] words = ctx.split(" ");
                String output = StringUtils.join((Object[])words, (String)" ", (int)0, (int)(maxWords <= words.length ? maxWords : words.length));
                if (safeString) {
                    return new Handlebars.SafeString((CharSequence)output);
                }
                return output;
            }
        });
        handlebars.registerHelper("if-wcm-mode", (Helper)new Helper<Map>(){

            public CharSequence apply(Map context, Options options) throws IOException {
                SlingHttpServletRequest request = (SlingHttpServletRequest)options.get("_request");
                String commaSeparatedList = (String)options.hash.get("mode");
                boolean result = false;
                if (commaSeparatedList != null && request != null) {
                    String[] modes = commaSeparatedList.split(",");
                    for (int i = 0; !result && i < modes.length; ++i) {
                        try {
                            WCMMode targetMode = WCMMode.valueOf(modes[i].trim().toUpperCase());
                            result |= targetMode == WCMMode.fromRequest((ServletRequest)request);
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                }
                return result ? options.fn() : options.inverse();
            }
        });
    }
}

