/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.commons.client.api.BaseQueryRequestInfo;
import com.adobe.cq.social.commons.client.api.CollectionPagination;
import com.adobe.cq.social.commons.client.api.SocialCollectionComponent;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.handlebars.HandlebarsScriptingEngineFactory;
import com.adobe.cq.social.handlebars.SlingResourceResolver;
import com.adobe.cq.social.handlebars.SlingTemplateSource;
import com.adobe.cq.social.handlebars.TemplateUtils;
import com.adobe.cq.social.handlebars.api.TemplateContextProvider;
import com.day.cq.commons.Externalizer;
import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlebarsScriptingEngine
extends AbstractSlingScriptEngine {
    private static final Logger LOG = LoggerFactory.getLogger(HandlebarsScriptingEngine.class);
    private final Handlebars handlebars;
    private final ResourceResolver adminResolver;

    public HandlebarsScriptingEngine(ScriptEngineFactory scriptEngineFactory, Handlebars handlebars, ResourceResolver adminResolver) {
        super(scriptEngineFactory);
        this.handlebars = handlebars;
        this.adminResolver = adminResolver;
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        try {
            Context hbContext;
            Bindings props = context.getBindings(100);
            SlingScriptHelper scriptHelper = (SlingScriptHelper)props.get("sling");
            SlingScript script = scriptHelper.getScript();
            SlingTemplateSource ts = new SlingTemplateSource(this.adminResolver.resolve(script.getScriptResource().getPath()), script.getScriptResource().getPath());
            Resource resource = scriptHelper.getRequest().getResource();
            long start = System.nanoTime();
            Template hbTemplate = this.handlebars.compile((TemplateSource)ts);
            LOG.debug("@@PERF@@ Compile Template|{}|{}", (Object)(System.nanoTime() - start), (Object)ts.filename());
            start = System.nanoTime();
            SlingHttpServletRequest request = scriptHelper.getRequest();
            SocialComponent socialComponent = ((HandlebarsScriptingEngineFactory)this.getFactory()).getSocialComponentForResource(resource, request);
            if (socialComponent != null) {
                LOG.debug("@@PERF@@ Component from Resource|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
            } else {
                LOG.debug("@@PERF@@ Component from Resource|{}|{}", (Object)(System.nanoTime() - start), (Object)"Sling including Component");
            }
            start = System.nanoTime();
            CollectionPagination paginationRequested = this.getPaginationFromRequest(request);
            if (socialComponent != null) {
                LOG.debug("@@PERF@@ Get Pagination|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
            } else {
                LOG.debug("@@PERF@@ Get Pagination|{}|{}", (Object)(System.nanoTime() - start), (Object)"Sling including component");
            }
            if (socialComponent != null) {
                Map<String, Object> contextMap;
                start = System.nanoTime();
                List<TemplateContextProvider> contextProviders = ((HandlebarsScriptingEngineFactory)this.getFactory()).getContextProviderService().getProviders(resource.getResourceType());
                LOG.debug("@@PERF@@ Get Providers|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
                if (paginationRequested != null && socialComponent instanceof SocialCollectionComponent) {
                    SocialCollectionComponent socialCollectionComponent = (SocialCollectionComponent)socialComponent;
                    start = System.nanoTime();
                    Map<String, Object> contextFromSocialComponent = socialCollectionComponent.getAsMap();
                    LOG.debug("@@PERF@@ Get as map|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
                    start = System.nanoTime();
                    contextMap = TemplateUtils.getMergedContexts(contextFromSocialComponent, contextProviders, scriptHelper.getRequest());
                    LOG.debug("@@PERF@@ merge contexts|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
                } else {
                    Map<String, Object> contextFromSocialComponent = socialComponent.getAsMap();
                    contextMap = TemplateUtils.getMergedContexts(contextFromSocialComponent, contextProviders, request);
                }
                start = System.nanoTime();
                hbContext = Context.newBuilder(contextMap).resolver(new ValueResolver[]{MapValueResolver.INSTANCE}).build();
                LOG.debug("@@PERF@@ Create Context|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
                if (request.getAttribute("_bypassComponentHandling") == null || !((Boolean)request.getAttribute("_bypassComponentHandling")).booleanValue()) {
                    String contextPath = this.getContextPath(this.adminResolver, request);
                    String contextScript = "<script type='application/json' id='" + resource.getPath() + "'";
                    if (!StringUtils.isEmpty((CharSequence)contextPath)) {
                        contextScript = contextScript + " data-context-path='" + contextPath + "'";
                    }
                    contextScript = contextScript + ">" + socialComponent.toJSONString(false) + "</script>";
                    context.getWriter().write(contextScript);
                }
                request.removeAttribute("_bypassComponentHandling");
            } else {
                hbContext = Context.newBuilder(this.buildContext(resource)).resolver(new ValueResolver[]{JavaBeanValueResolver.INSTANCE, SlingResourceResolver.INSTANCE, MapValueResolver.INSTANCE}).build();
            }
            start = System.nanoTime();
            hbContext.data("_request", (Object)scriptHelper.getRequest());
            hbContext.data("_response", (Object)scriptHelper.getResponse());
            hbTemplate.apply(hbContext, context.getWriter());
            hbContext.destroy();
            if (socialComponent != null) {
                LOG.debug("@@PERF@@ Write html|{}|{}", (Object)(System.nanoTime() - start), (Object)socialComponent.getId());
            } else {
                LOG.debug("@@PERF@@ Write html|{}|{}", (Object)(System.nanoTime() - start), (Object)"Sling Include a component");
            }
        }
        catch (IOException e) {
            new ScriptException(e);
        }
        return null;
    }

    private String getContextPath(ResourceResolver resolver, SlingHttpServletRequest request) {
        Externalizer externalizer = resolver.adaptTo(Externalizer.class);
        String relativeLink = externalizer.relativeLink(request, "");
        return StringUtils.removeEnd((String)relativeLink, (String)"/");
    }

    private Map<String, Object> buildContext(Resource resource) {
        Map context = resource.adaptTo(ValueMap.class);
        return context;
    }

    protected CollectionPagination getPaginationFromRequest(SlingHttpServletRequest request) {
        BaseQueryRequestInfo qri = new BaseQueryRequestInfo(request);
        return qri.getPagination();
    }
}

