/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LoadMoreHelper
implements Helper<Map<String, Object>> {
    public static final String name = "loadmore";

    public CharSequence apply(Map<String, Object> context, Options options) throws IOException {
        if (!context.containsKey("totalSize") || !context.containsKey("pageInfo")) {
            return "";
        }
        Map pageInfo = (Map)context.get("pageInfo");
        if (pageInfo.containsKey("selectedPage") && context.containsKey("totalSize") && pageInfo.containsKey("pageSize")) {
            String output = "";
            if ((Integer)context.get("totalSize") <= 0) {
                return output;
            }
            HashMap tempMap = new HashMap();
            tempMap.put("suffix", pageInfo.get("nextSuffix"));
            long remaining = ((Integer)context.get("totalSize")).intValue();
            if (context.containsKey("items")) {
                remaining -= (long)((List)context.get("items")).size();
            }
            long pageSize = (Long)pageInfo.get("pageSize");
            long pagesSeen = (Long)pageInfo.get("selectedPage") - 1L;
            if (pagesSeen > 0L) {
                remaining -= pagesSeen * pageSize;
            }
            if (remaining == 0L) {
                return output;
            }
            String url = (String)pageInfo.get("nextPageURL");
            if (url != null && url.endsWith(".json")) {
                url = StringUtils.removeEnd((String)url, (String)".json");
                url = url + ".html";
            }
            tempMap.put("remaining", remaining);
            tempMap.put("moreURL", url);
            output = output + options.apply(options.fn, tempMap);
            return output;
        }
        return "";
    }
}

