/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.github.jknack.handlebars.io.AbstractTemplateSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingTemplateSource
extends AbstractTemplateSource {
    private static final Logger LOG = LoggerFactory.getLogger(SlingTemplateSource.class);
    private final Resource resource;
    private final String location;

    public SlingTemplateSource(Resource resource, String location) {
        this.resource = resource;
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String content() throws IOException {
        Reader reader = null;
        int bufferSize = 1024;
        try {
            int len;
            reader = this.reader();
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder(1024);
            while ((len = reader.read(cbuf, 0, 1024)) != -1) {
                sb.append(cbuf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public Reader reader() throws IOException {
        InputStream is = this.resource.adaptTo(InputStream.class);
        return new InputStreamReader(is, "UTF-8");
    }

    public String filename() {
        return StringUtils.substringAfterLast((String)this.location, (String)"/");
    }

    public long lastModified() {
        Node node = this.resource.adaptTo(Node.class);
        try {
            if (node.hasProperty("jcr:lastModified")) {
                return node.getProperty("jcr:lastModified").getLong();
            }
            return node.getProperty("jcr:created").getLong();
        }
        catch (ValueFormatException e) {
            LOG.error(e.getMessage());
            return 0L;
        }
        catch (PathNotFoundException e) {
            LOG.error(e.getMessage());
            return 0L;
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage());
            return 0L;
        }
    }
}

