/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class TemplateLocationIterator
implements Iterator<String> {
    private final ResourceResolver resolver;
    private final String[] searchPath;
    private int pathCounter;
    private String resourceType;
    private String relPath;
    private String nextLocation;
    private final Set<String> usedResourceTypes = new HashSet<String>();

    public TemplateLocationIterator(String resourceType, ResourceResolver resolver) {
        this.resolver = resolver;
        String[] tmpPath = resolver.getSearchPath();
        if (tmpPath == null || tmpPath.length == 0) {
            tmpPath = new String[]{"/"};
        }
        this.searchPath = tmpPath;
        this.resourceType = resourceType;
        this.usedResourceTypes.add(this.resourceType);
        this.nextLocation = this.seek();
    }

    @Override
    public boolean hasNext() {
        return this.nextLocation != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String result = this.nextLocation;
        this.nextLocation = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private String seek() {
        if (this.relPath == null) {
            if (this.resourceType == null) {
                return null;
            }
            String typePath = ResourceUtil.resourceTypeToPath(this.resourceType);
            if (typePath.startsWith("/")) {
                this.resourceType = this.getResourceSuperType(this.resourceType);
                return typePath;
            }
            this.relPath = typePath;
        }
        String result = this.searchPath[this.pathCounter].concat(this.relPath);
        ++this.pathCounter;
        if (this.pathCounter >= this.searchPath.length) {
            this.relPath = null;
            this.resourceType = this.getResourceSuperType(this.resourceType);
            this.pathCounter = 0;
        }
        return result;
    }

    private String getResourceSuperType(String resourceType) {
        String superType = this.resolver.getParentResourceType(resourceType);
        if (superType != null) {
            if (this.usedResourceTypes.contains(superType)) {
                superType = null;
            } else {
                this.usedResourceTypes.add(superType);
            }
        }
        return superType;
    }
}

