/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.handlebars;

import com.adobe.cq.social.handlebars.HandlebarsScriptingEngineFactory;
import com.adobe.cq.social.handlebars.SlingTemplateSource;
import com.adobe.cq.social.handlebars.TemplateContextProviderService;
import com.adobe.cq.social.handlebars.TemplateUtils;
import com.adobe.cq.social.handlebars.api.TemplateHelpersService;
import com.day.cq.rewriter.linkchecker.LinkCheckerSettings;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"hbs", "chbs"}, propertyPrivate=true), @Property(name="sling.servlet.paths", value={"/services/social/templates"})})
public class TemplateServlet
extends SlingAllMethodsServlet {
    private static final String EXT = "ext";
    private static final String SELECTOR = "selector";
    private static final long serialVersionUID = 1L;
    @Reference
    private final ResourceResolverFactory rrf = null;
    @Reference
    private final TemplateHelpersService templateHelperService = null;
    @Reference
    private TemplateContextProviderService contextProviderService;
    private static final String RESOURCE_TYPE = "resourceType";

    @Override
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String selectorString;
        LinkCheckerSettings.fromRequest(request).setIgnoreExternals(false);
        LinkCheckerSettings.fromRequest(request).setIgnoreExternals(true);
        Resource resource = request.getResource();
        ResourceResolver adminResolver = null;
        String resourceTypeFromRequest = request.getParameter(RESOURCE_TYPE);
        String selectorFromRequest = request.getParameter(SELECTOR);
        String extensionRequested = request.getParameter(EXT);
        String extension = extensionRequested == null ? request.getRequestPathInfo().getExtension() : extensionRequested;
        String string = selectorString = selectorFromRequest == null ? request.getRequestPathInfo().getSelectorString() : selectorFromRequest;
        if (resourceTypeFromRequest == null && ResourceUtil.isNonExistingResource(resource)) {
            response.setStatus(404);
            return;
        }
        String resourceType = resourceTypeFromRequest == null ? resource.getResourceType() : resourceTypeFromRequest;
        try {
            adminResolver = this.rrf.getAdministrativeResourceResolver(null);
            Resource template = TemplateUtils.findTemplate(adminResolver, resourceType, selectorString);
            if (template == null) {
                response.setStatus(404);
                return;
            }
            if (StringUtils.equals((CharSequence)"hbs", (CharSequence)extension)) {
                InputStream in = TemplateUtils.getTemplateStream(template);
                String templateData = IOUtils.toString((InputStream)in);
                response.setContentType("application/text");
                response.setHeader("Cache-Control", "no-transform,public,max-age=300,s-maxage=900");
                response.getWriter().append(templateData);
                response.setStatus(200);
                return;
            }
            if (StringUtils.equals((CharSequence)"chbs", (CharSequence)extension)) {
                SlingTemplateSource ts = new SlingTemplateSource(template, template.getPath());
                Handlebars hb = HandlebarsScriptingEngineFactory.HANDLEBARS;
                Template hbTemplate = hb.compile((TemplateSource)ts);
                String compiledJS = hbTemplate.toJavaScript();
                response.setContentType("application/javascript");
                response.getWriter().append(compiledJS);
                response.setStatus(200);
                return;
            }
            response.setStatus(404);
            return;
        }
        catch (LoginException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
    }

    private void writeScriptBlockProlog(PrintWriter writer, String name) {
        writer.append("<script type=\"text/x-handlebars-template\" id=\"" + StringUtils.removeEndIgnoreCase((String)name, (String)".hbs") + "\">");
    }

    private void writeScriptBlockEpilog(PrintWriter writer) {
        writer.append("</script>");
    }

    private void writeHBWrapper(PrintWriter writer, String function) {
        writer.append("template(" + function + ");");
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }

    protected void bindTemplateHelperService(TemplateHelpersService templateHelpersService) {
        this.templateHelperService = templateHelpersService;
    }

    protected void unbindTemplateHelperService(TemplateHelpersService templateHelpersService) {
        if (this.templateHelperService == templateHelpersService) {
            this.templateHelperService = null;
        }
    }

    protected void bindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        this.contextProviderService = templateContextProviderService;
    }

    protected void unbindContextProviderService(TemplateContextProviderService templateContextProviderService) {
        if (this.contextProviderService == templateContextProviderService) {
            this.contextProviderService = null;
        }
    }
}

