/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal;

import com.adobe.cq.social.journal.JournalEntry;
import com.adobe.cq.social.journal.JournalEntryFilter;

public class ParentPathEntryFilter
implements JournalEntryFilter {
    private final String parentPath;

    public ParentPathEntryFilter(String path) {
        this.parentPath = path;
    }

    @Override
    public boolean pass(JournalEntry entry) {
        if (this.parentPath == null) {
            return true;
        }
        try {
            String entryParentPath = entry.getPage().getParent().getPath();
            if (this.parentPath.indexOf("/") != -1) {
                return entryParentPath.endsWith(this.parentPath);
            }
            return entryParentPath.indexOf(this.parentPath) != -1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

