/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal.search.process;

import com.adobe.cq.social.journal.Journal;
import com.adobe.cq.social.journal.JournalEntry;
import com.adobe.cq.social.journal.JournalManager;
import com.adobe.cq.social.journal.search.JournalSearchPingService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Social Journal Search Ping"})
public class JournalSearchPingProcess
implements WorkflowProcess {
    public static final String TYPE_JCR_PATH = "JCR_PATH";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Reference
    private JournalSearchPingService journalSearchPingService;
    @Reference
    private JcrResourceResolverFactory jcrResourceResolverFactory;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session session = workflowSession.getSession();
        WorkflowData data = workItem.getWorkflowData();
        String path = null;
        String type = data.getPayloadType();
        try {
            String payloadData;
            if (type.equals(TYPE_JCR_PATH) && data.getPayload() != null && session.itemExists(payloadData = (String)data.getPayload())) {
                path = payloadData;
            }
            if (path != null) {
                Node journalPost = (Node)session.getItem(path);
                ResourceResolver resourceResolver = this.jcrResourceResolverFactory.getResourceResolver(session);
                Resource resource = resourceResolver.getResource(path);
                JournalManager journalManager = resource.getResourceResolver().adaptTo(JournalManager.class);
                Journal journal = journalManager.getJournal(path);
                if (journal != null && journal.isEntry()) {
                    JournalEntry entry = journal.getEntry();
                    this.journalSearchPingService.ping(journal.getTitle(), journal.getFullUrl(), entry.getFullUrl(), journal.getFeedUrl(true));
                    this.logger.info("Submitted this item to journal search engines: " + workItem.toString());
                } else {
                    this.logger.warn("Cannot submit this item to journal search engines: " + workItem.toString());
                }
            } else {
                this.logger.warn("Cannot submit this item to journal search engines: " + workItem.toString());
            }
        }
        catch (RepositoryException e) {
            throw new WorkflowException(e);
        }
    }

    protected void bindJournalSearchPingService(JournalSearchPingService journalSearchPingService) {
        this.journalSearchPingService = journalSearchPingService;
    }

    protected void unbindJournalSearchPingService(JournalSearchPingService journalSearchPingService) {
        if (this.journalSearchPingService == journalSearchPingService) {
            this.journalSearchPingService = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }
}

