/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.journal.trackback;

import com.adobe.cq.social.journal.JournalEntry;
import com.adobe.cq.social.journal.JournalException;
import com.day.cq.xss.XSSProtectionException;
import com.day.cq.xss.XSSProtectionService;
import com.day.text.Text;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.description", value={"Trackback Servlet"}), @Property(name="sling.servlet.resourceTypes", value={"cq/Page"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="sling.servlet.selectors", value={"trackback"}), @Property(name="reverseReplicate", boolValue={true})})
public class TrackbackServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 1L;
    @Reference
    private XSSProtectionService xssProtectionService;
    @Reference
    protected JcrResourceResolverFactory jcrResourceResolverFactory;
    @Reference
    protected SlingRepository repository;
    static final String PROPERTY_REVERSE_REPLICATE = "reverseReplicate";
    static final boolean DEFAULT_REVERSE_REPLICATE = true;
    private boolean reverseReplicate;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Session session = null;
        response.setContentType("text/xml");
        if (!request.getContentType().equalsIgnoreCase("application/x-www-form-urlencoded")) {
            response.getOutputStream().print(this.error("content type must be application/x-www-form-urlencoded but is " + request.getContentType()));
            response.getOutputStream().flush();
            return;
        }
        if (request.getParameter("url") == null) {
            response.getOutputStream().print(this.error("client must send a url"));
            response.getOutputStream().flush();
            return;
        }
        try {
            session = this.repository.loginAdministrative(null);
            this.createTrackbackNode(session, request);
            response.getOutputStream().print(this.success());
            response.getOutputStream().flush();
        }
        catch (JournalException be) {
            response.getOutputStream().print(this.error("unspecified error"));
            this.log.error(be.getMessage());
            response.getOutputStream().flush();
        }
        catch (XSSProtectionException e) {
            response.getOutputStream().print(this.error("xssprotection error"));
            this.log.error(e.getMessage());
        }
        catch (RepositoryException e) {
            response.getOutputStream().print(this.error("RepositoryException error"));
            this.log.error(e.getMessage());
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
                session = null;
            }
        }
    }

    private void createTrackbackNode(Session session, SlingHttpServletRequest request) throws JournalException, XSSProtectionException {
        String checkPath;
        Resource resource = this.jcrResourceResolverFactory.getResourceResolver(session).getResource(request.getResource().getPath());
        JournalEntry journalEntry = resource.adaptTo(JournalEntry.class);
        Session checkSession = request.getResourceResolver().adaptTo(Session.class);
        if (!this.hasPermission(checkSession, checkPath = Text.getAbsoluteParent("/content/usergenerated", 1))) {
            return;
        }
        String title = "";
        if (request.getParameter("title") != null) {
            title = request.getParameter("title");
        }
        String excerpt = "";
        if (request.getParameter("excerpt") != null) {
            excerpt = request.getParameter("excerpt");
        }
        String url = "";
        if (request.getParameter("url") != null) {
            url = request.getParameter("url");
        }
        String journalName = "";
        if (request.getParameter("journal_name") != null) {
            journalName = request.getParameter("journal_name");
        }
        journalEntry.addTrackback(title, excerpt, url, journalName, request.getRemoteAddr());
        journalEntry.save();
    }

    private String success() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>0</error></response>";
    }

    private String error(String message) {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?><response><error>1</error><message>" + message + "</message></response>";
    }

    protected boolean hasPermission(Session session, String path) {
        if (session == null) {
            this.log.error("session must not be null");
            return false;
        }
        try {
            this.log.debug("check if user '" + session.getUserID() + "' is allowed to add nodes under " + path);
            session.checkPermission(path + "/_add_node_" + System.currentTimeMillis(), "add_node");
            return true;
        }
        catch (Exception e) {
            this.log.error("user '" + session.getUserID() + "' not allowed to add nodes under " + path, (Throwable)e);
            return false;
        }
    }

    protected void bindXssProtectionService(XSSProtectionService xSSProtectionService) {
        this.xssProtectionService = xSSProtectionService;
    }

    protected void unbindXssProtectionService(XSSProtectionService xSSProtectionService) {
        if (this.xssProtectionService == xSSProtectionService) {
            this.xssProtectionService = null;
        }
    }

    protected void bindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.jcrResourceResolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindJcrResourceResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.jcrResourceResolverFactory == jcrResourceResolverFactory) {
            this.jcrResourceResolverFactory = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

