/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.api;

import com.adobe.cq.social.commons.events.SocialEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.event.Event;

public final class MessagingEvent
extends SocialEvent<MessagingActions> {
    private static final long serialVersionUID = 1L;
    private static final String MESSAGE_TOPIC = "message";
    public static final String EVENT_TOPIC = "com/adobe/cq/social/message";
    private static final String PN_PROPERTIES_MODIFIED = "propertiesUpdated";
    private static final String PN_RECIPIENT_MESSAGE_PATHS = "pathsToSentMessages";

    public MessagingEvent(String messagePath, List<String> createdMessagePaths, String userId, MessagingActions messagingAction, List<String> modifiedProperties) {
        super(MESSAGE_TOPIC, messagePath, userId, messagingAction, MessagingEvent.buildProperties(modifiedProperties, createdMessagePaths));
    }

    public static MessagingEvent fromEvent(Event event) {
        if (event instanceof MessagingEvent) {
            return (MessagingEvent)event;
        }
        return null;
    }

    public List<String> getUpdatedProperties() {
        return (List)this.getProperty(PN_PROPERTIES_MODIFIED);
    }

    public List<String> getPathsToReceivedMessages() {
        return (List)this.getProperty(PN_RECIPIENT_MESSAGE_PATHS);
    }

    private static Map<String, Object> buildProperties(List<String> modifiedProperties, List<String> createdMessagePaths) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (modifiedProperties != null && !modifiedProperties.isEmpty()) {
            objectMap.put(PN_PROPERTIES_MODIFIED, modifiedProperties);
        }
        if (createdMessagePaths != null && !createdMessagePaths.isEmpty()) {
            objectMap.put(PN_RECIPIENT_MESSAGE_PATHS, createdMessagePaths);
        }
        return objectMap;
    }

    public static enum MessagingActions implements SocialEvent.SocialActions
    {
        MessageSent,
        MessageUpdated,
        MessageDeleted;

    }
}

