/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.messaging.client.api;

import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialCollectionComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponent;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.messaging.api.MessagingService;
import com.adobe.cq.social.messaging.client.api.AbstractMessagingComponentFactory;
import com.adobe.cq.social.messaging.client.impl.MessageBoxSocialComponentImpl;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="AEM Social Communities MessageBoxSocialComponentFactory")
@Service(value={SocialCollectionComponentFactory.class, SocialComponentFactory.class})
public class MessageBoxSocialComponentFactory
extends AbstractMessagingComponentFactory
implements SocialCollectionComponentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MessageBoxSocialComponentFactory.class);
    private static final String MESSAGE_BOX_RESOURCE_TYPE = "social/messaging/components/hbs/messagebox";
    @Reference
    private MessagingService messagingService;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        throw new UnsupportedOperationException("Message box cannot be created without a valid sling request.");
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest slingRequest) {
        if (resource == null || slingRequest == null) {
            throw new IllegalArgumentException("Cannot create message box without a valid resource or sling request.");
        }
        try {
            return new MessageBoxSocialComponentImpl(resource, this.getClientUtilities(slingRequest), this.getQueryRequestInfo(slingRequest), this.messagingService, this.getUserPropertiesService());
        }
        catch (RepositoryException e) {
            LOG.error("Could not obtain message box for resource at {}", (Object)resource.getPath(), (Object)e);
            return null;
        }
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo) {
        throw new UnsupportedOperationException("Message box cannot be created without a valid sling request.");
    }

    @Override
    public String getSupportedResourceType() {
        return MESSAGE_BOX_RESOURCE_TYPE;
    }

    protected void bindMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected void unbindMessagingService(MessagingService messagingService) {
        if (this.messagingService == messagingService) {
            this.messagingService = null;
        }
    }
}

