/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.qna.api;

import com.adobe.cq.social.commons.events.SocialEvent;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;

public class QnaEvent
extends SocialEvent<QnaActions> {
    private static final String QUESTION_PATH = "QUESTION_PATH";
    public static final String QNA_TOPIC = "qna";
    private static final String ANSWER_PATH = "ANSWER_PATH";
    private static final String QNA_FORUM_PATH = "QNA_FORUM_PATH";
    private static final long serialVersionUID = 1L;

    private QnaEvent(String path, String userId, QnaActions action, Map<String, Object> additionalData) {
        super(QNA_TOPIC, path, userId, action, additionalData);
    }

    private QnaEvent(Event event) {
        super(event);
    }

    private static QnaEvent buildQuestionEvent(String questionPath, String userId, String qnaForumPath, QnaActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(1);
        addData.put(QNA_FORUM_PATH, qnaForumPath);
        return new QnaEvent(questionPath, userId, action, addData);
    }

    public static QnaEvent answerSelected(String questionPath, String answerPath, String qnaForumPath, String userId) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        addData.put(QNA_FORUM_PATH, qnaForumPath);
        addData.put(ANSWER_PATH, answerPath);
        return new QnaEvent(questionPath, userId, QnaActions.ANSWER_SELECTED, addData);
    }

    public static QnaEvent answerUnselected(String questionPath, String answerPath, String qnaForumPath, String userId) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        addData.put(QNA_FORUM_PATH, qnaForumPath);
        addData.put(ANSWER_PATH, answerPath);
        return new QnaEvent(questionPath, userId, QnaActions.ANSWER_UNSELECTED, addData);
    }

    public String getQnaForumPath() {
        return (String)this.getProperty(QNA_FORUM_PATH);
    }

    public String getAnswerPath() {
        return QnaActions.ANSWER_CREATED.equals(this.getAction()) || QnaActions.ANSWER_DELETED.equals(this.getAction()) || QnaActions.ANSWER_EDITED.equals(this.getAction()) ? this.getPath() : (String)this.getProperty(ANSWER_PATH);
    }

    public String getQuestionPath() {
        return QnaActions.ANSWER_CREATED.equals(this.getAction()) || QnaActions.ANSWER_DELETED.equals(this.getAction()) || QnaActions.ANSWER_EDITED.equals(this.getAction()) ? (String)this.getProperty(QUESTION_PATH) : this.getPath();
    }

    public static QnaEvent questionCreated(String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildQuestionEvent(questionPath, userId, qnaForumPath, QnaActions.QUESTION_CREATED);
    }

    public static QnaEvent questionEdited(String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildQuestionEvent(questionPath, userId, qnaForumPath, QnaActions.QUESTION_EDITED);
    }

    public static QnaEvent questionDeleted(String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildQuestionEvent(questionPath, userId, qnaForumPath, QnaActions.QUESTION_DELETED);
    }

    public static QnaEvent answerCreated(String answerPath, String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildAnswerEvent(answerPath, userId, qnaForumPath, questionPath, QnaActions.ANSWER_CREATED);
    }

    public static QnaEvent answerDeleted(String answerPath, String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildAnswerEvent(answerPath, userId, qnaForumPath, questionPath, QnaActions.ANSWER_DELETED);
    }

    public static QnaEvent answerEdited(String answerPath, String questionPath, String qnaForumPath, String userId) {
        return QnaEvent.buildAnswerEvent(answerPath, userId, qnaForumPath, questionPath, QnaActions.ANSWER_EDITED);
    }

    private static QnaEvent buildAnswerEvent(String path, String userId, String qnaForumPath, String questionPath, QnaActions action) {
        HashMap<String, Object> addData = new HashMap<String, Object>(2);
        addData.put(QNA_FORUM_PATH, qnaForumPath);
        addData.put(QUESTION_PATH, questionPath);
        return new QnaEvent(path, userId, action, addData);
    }

    public static QnaEvent fromEvent(Event event) {
        if ("com/adobe/cq/social/qna".equals(event.getTopic())) {
            return new QnaEvent(event);
        }
        return null;
    }

    public static enum QnaActions implements SocialEvent.SocialActions
    {
        QUESTION_CREATED,
        QUESTION_EDITED,
        QUESTION_DELETED,
        ANSWER_SELECTED,
        ANSWER_UNSELECTED,
        ANSWER_CREATED,
        ANSWER_EDITED,
        ANSWER_DELETED;

    }
}

