/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.review.client.api;

import com.adobe.cq.social.commons.CollabUtil;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.commons.client.api.QueryRequestInfo;
import com.adobe.cq.social.commons.client.api.SocialComponentFactory;
import com.adobe.cq.social.commons.client.api.SocialComponentFactoryManager;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.api.ReviewCollectionSocialComponent;
import com.adobe.cq.social.review.client.api.ReviewSocialComponent;
import com.adobe.cq.social.tally.ResponseValue;
import com.adobe.cq.social.tally.TallyException;
import com.adobe.cq.social.tally.client.api.RatingSocialComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReviewCollection<R extends ReviewSocialComponent, C extends CommentCollectionConfiguration>
extends AbstractCommentCollection<R, C>
implements ReviewCollectionSocialComponent<R, C> {
    protected final ResourceResolver resolver;
    protected final Resource ugcResource;
    protected final String authorizableUserID;
    protected Map<String, RatingSocialComponent> ratings;
    protected RatingSocialComponent overallRating;
    private List<Map<String, String>> allowedRatings;
    private boolean includeHistogram = false;
    private static final String JCR_CONTENT = "_jcr_content";
    private static final String PAR = "/par";
    protected static final String NAME_KEY = "name";
    protected static final String REQUIRED_KEY = "required";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReviewCollection.class);

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.resolver = resource.getResourceResolver();
        this.ugcResource = this.resolver.resolve(CollabUtil.resourceToUGCPath(resource));
        this.authorizableUserID = this.getLoggedInUser();
        this.ratings = this.getRatings(clientUtils);
        this.overallRating = this.getOverallRating(clientUtils);
    }

    private RatingSocialComponent getOverallRating(ClientUtilities clientUtils) {
        Resource resource = this.ugcResource.getParent();
        if (resource != null) {
            resource = resource.getChild(this.resource.getName() + "_" + "Overall");
        }
        return this.getRatingSocialComponentFromResource(resource, clientUtils);
    }

    private Map<String, RatingSocialComponent> getRatings(ClientUtilities clientUtils) {
        HashMap<String, RatingSocialComponent> results = new HashMap<String, RatingSocialComponent>();
        Resource resource = this.ugcResource.getParent();
        if (resource != null) {
            for (Resource child : resource.getChildren()) {
                String name;
                if (!this.resolver.isResourceType(child, "social/tally/components/hbs/rating") || !child.getName().startsWith(this.ugcResource.getName()) || !this.isRatingAllowed(name = child.getName().substring(this.ugcResource.getName().length() + 1))) continue;
                RatingSocialComponent rating = this.getRatingSocialComponentFromResource(child, clientUtils);
                results.put(name, rating);
            }
        }
        return results;
    }

    private boolean isRatingAllowed(String name) {
        List<Map<String, String>> allowed = this.getAllowedRatings();
        for (Map<String, String> map : allowed) {
            if (map == null || !StringUtils.equals((CharSequence)map.get(NAME_KEY), (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    private RatingSocialComponent getRatingSocialComponentFromResource(Resource resource, ClientUtilities clientUtils) {
        SocialComponentFactory scf;
        SocialComponentFactoryManager scfMgr;
        if (resource != null && (scfMgr = clientUtils.getSocialComponentFactoryManager()) != null && (scf = scfMgr.getSocialComponentFactory(resource)) != null) {
            return (RatingSocialComponent)scf.getSocialComponent(resource);
        }
        return null;
    }

    private String getLoggedInUser() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.adaptTo(Session.class).getUserID();
    }

    @Override
    public String getName() {
        return this.getProperties().getProperty(NAME_KEY);
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return new Long(this.getTotalSize());
    }

    @Override
    public Map<String, ResponseValue> getCurrentUserResponse() throws TallyException, RepositoryException {
        HashMap<String, ResponseValue> results = new HashMap<String, ResponseValue>();
        ResponseValue comment = new ResponseValue(){

            @Override
            public String getResponseValue() {
                return AbstractReviewCollection.this.getCurrentUserComment();
            }
        };
        results.put("comment", comment);
        if (this.overallRating != null) {
            results.put(this.overallRating.getName(), this.overallRating.getCurrentUserResponse());
        }
        return results;
    }

    private String getCurrentUserComment() {
        return "";
    }

    @Override
    public Map<String, RatingSocialComponent> getRatings() {
        return this.ratings;
    }

    @Override
    public Map<String, String> getRatingAverages() {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (Map<String, String> map : this.allowedRatings) {
            if (map == null || map.get(NAME_KEY) == null) continue;
            String name = map.get(NAME_KEY);
            if (this.ratings.get(name) != null) {
                results.put(name, this.ratings.get(name).getFormattedAverageRating());
                continue;
            }
            results.put(name, null);
        }
        return results;
    }

    private void buildAllowedRatings() {
        Resource resource = this.resolver.resolve(this.resource.getPath());
        ValueMap values = resource.adaptTo(ValueMap.class);
        String[] ratings = values.get("allowedRatings", new String[]{"Overall"});
        this.allowedRatings = new ArrayList<Map<String, String>>(ratings.length);
        String[] required = values.get("requiredRatings", new String[]{"Overall"});
        List<String> requiredList = Arrays.asList(required);
        for (String subrating : ratings) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(NAME_KEY, subrating);
            if (requiredList.contains(subrating)) {
                map.put(REQUIRED_KEY, "true");
            }
            this.allowedRatings.add(map);
        }
    }

    @Override
    public List<Map<String, String>> getAllowedRatings() {
        if (null == this.allowedRatings) {
            this.buildAllowedRatings();
        }
        return this.allowedRatings;
    }

    @Override
    public boolean isCompositeRating() {
        if (this.getAllowedRatings() == null) {
            return false;
        }
        return this.getAllowedRatings().size() != 1;
    }

    @Override
    public boolean isIncludeHistogram() {
        return this.includeHistogram;
    }

    protected void setIncludeHistogram(boolean include) {
        this.includeHistogram = include;
    }
}

