/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.sc.lucene;

import com.adobe.cq.social.sc.lucene.DateField;
import com.adobe.cq.social.sc.lucene.DecimalField;
import com.adobe.cq.social.sc.lucene.DoubleField;
import com.adobe.cq.social.sc.lucene.LongField;
import com.adobe.cq.social.sc.lucene.NodeIndexer;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.index.CategoryDocumentBuilder;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeIndexer
implements NodeIndexer {
    private static final String primaryType = "jcr:primaryType";
    private static final String FIELD_UUID = ":uuid";
    private static final String FIELD_FULLTEXT = ":fulltext";
    private static final String FIELD_PRIMARY_TYPE = "jcr:primaryType";
    private static final String FIELD_PATH = ":path";
    private static final String FIELD_PARENT = ":parent";
    private static final String FIELD_NAME = ":name";
    private static final String FIELD_LOCAL = ":local";
    private static final String FIELD_PROPERTIES = ":properties";
    private static final Term TERM_PATH = new Term(":path");
    private static final int DEFAULT_MAX_AGGREGATION_LEVELS = 25;
    private static final List<String> DEFAULT_SKIP_PROPERTIES_LIST = Arrays.asList("sling:*", "jcr:created", "jcr:createdBy", "jcr:lastModified", "jcr:lastModifiedBy", "cq:template", "cq:toolbars", "cq:lastModified", "cq:lastModifiedBy", "textIsRich", "isDate");
    private static final Logger log = LoggerFactory.getLogger(DefaultNodeIndexer.class);

    @Override
    public Query getSubtreeQuery(String path) {
        return new TermQuery(TERM_PATH.createTerm(path));
    }

    @Override
    public Document createDocument(Node node, CategoryDocumentBuilder categoryDocBuilder) throws RepositoryException {
        log.debug("Started to create lucene doc for {} / {}.", (Object)node.getPath(), (Object)node.getPrimaryNodeType().getName());
        long t = System.currentTimeMillis();
        Document document = new Document();
        document.add((Fieldable)new Field(FIELD_UUID, false, node.getIdentifier(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        document.add((Fieldable)new Field("jcr:primaryType", false, node.getPrimaryNodeType().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        document.add((Fieldable)new Field(FIELD_PATH, false, node.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        try {
            document.add((Fieldable)new Field(FIELD_PARENT, false, node.getParent().getPath(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        String name = node.getName();
        document.add((Fieldable)new Field(FIELD_NAME, false, name, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        name = name.substring(name.indexOf(58) + 1);
        document.add((Fieldable)new Field(FIELD_LOCAL, false, name, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        for (Property property : JcrUtils.getProperties(node)) {
            name = property.getName();
            if (this.shouldSkipProperty(name)) continue;
            document.add((Fieldable)new Field(FIELD_PROPERTIES, false, name, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            if (property.isMultiple()) {
                for (Value value : property.getValues()) {
                    this.addValue(document, name, value, false);
                }
                continue;
            }
            this.addValue(document, name, property.getValue(), false);
        }
        this.copyAggregatesFromOriginal(node, document);
        log.debug("Created lucene doc for {} took {} ms.", (Object)node.getIdentifier(), (Object)(System.currentTimeMillis() - t));
        return document;
    }

    protected void copyAggregatesFromOriginal(Node node, Document doc) throws RepositoryException {
        this.copyAggregatesFromOriginal(node, doc, 0);
    }

    private void copyAggregatesFromOriginal(Node node, Document doc, int level) throws RepositoryException {
        if (level == this.getAggregationMaxLevelsDeep()) {
            return;
        }
        for (Node c : JcrUtils.getChildNodes(node)) {
            if (this.shouldSkipChildNode(node, c, level + 1)) continue;
            this.copyAggregatesFromOriginal(c, doc, level + 1);
        }
        if (level > 0) {
            for (Property p : JcrUtils.getProperties(node)) {
                if (this.shouldSkipProperty(p.getName())) continue;
                if (p.isMultiple()) {
                    for (Value value : p.getValues()) {
                        this.addValue(doc, p.getName(), value, true);
                    }
                    continue;
                }
                this.addValue(doc, p.getName(), p.getValue(), true);
            }
        }
    }

    protected boolean shouldSkipChildNode(Node node, Node child, int levelDeep) {
        return false;
    }

    private boolean shouldSkipProperty(String name) {
        List<String> skips = this.skipProperties();
        if (skips == null) {
            return false;
        }
        for (String p : skips) {
            if (p.startsWith("*") && p.endsWith("*") && name.contains(p)) {
                return true;
            }
            if (p.startsWith("*") && name.endsWith(p)) {
                return true;
            }
            if (p.endsWith("*") && name.startsWith(p)) {
                return true;
            }
            if (p.equals(name)) {
                return true;
            }
            if (!"jcr:primaryType".equals(name)) continue;
            return true;
        }
        return false;
    }

    protected List<String> skipProperties() {
        return DEFAULT_SKIP_PROPERTIES_LIST;
    }

    protected int getAggregationMaxLevelsDeep() {
        return 25;
    }

    private void addValue(Document document, String name, Value value, boolean isFullText) throws RepositoryException {
        if (value.getType() != 2) {
            String fulltext;
            String typed = fulltext = value.getString();
            if (value.getType() == 5) {
                typed = DateField.dateToString(value.getDate().getTime());
            } else if (value.getType() == 4) {
                typed = DoubleField.doubleToString(value.getDouble());
            } else if (value.getType() == 3) {
                typed = LongField.longToString(value.getLong());
            } else if (value.getType() == 12) {
                typed = DecimalField.decimalToString(value.getDecimal());
            }
            if (!isFullText) {
                document.add((Fieldable)new Field(name, typed, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
                document.add((Fieldable)new Field(":fulltext:" + name, fulltext, Field.Store.NO, Field.Index.ANALYZED_NO_NORMS));
            }
            document.add((Fieldable)new Field(FIELD_FULLTEXT, false, fulltext, Field.Store.NO, Field.Index.ANALYZED_NO_NORMS, Field.TermVector.NO));
        }
    }
}

