/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.storage.index;

import com.adobe.cq.social.storage.buckets.NestedBucketStorageSystem;
import com.adobe.cq.social.storage.index.IndexUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseReindexer {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseReindexer.class);
    private static final int PROGRESS_LOG_COUNT = 100;
    private Thread wThread = null;

    protected void startReindexing() {
        this.wThread = new Thread(new WorkerThread());
        this.wThread.start();
    }

    protected abstract void performReindexing();

    public abstract boolean checkResource(Resource var1);

    public abstract String getUGCPath(Resource var1);

    public abstract String getTopLevelPrefix();

    public abstract String getLowerLevelPrefix();

    public abstract void indexExec(ResourceResolver var1, String var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> findReindexPaths(ResourceResolverFactory resolverFactory, String rootPath, String componentPathProp) {
        ResourceResolver resolver = null;
        LinkedList<String> results = new LinkedList<String>();
        try {
            resolver = resolverFactory.getAdministrativeResourceResolver(null);
            Resource root = resolver.getResource(rootPath);
            if (root == null) {
                List<String> list = null;
                return list;
            }
            this.findReindexPaths(resolver, root.adaptTo(Node.class), results, componentPathProp);
        }
        catch (LoginException e) {
            log.error("LoginException while searching for reindex paths", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("RepositoryException while searching for reindex paths", (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return results;
    }

    protected abstract long getIndexSize(ResourceResolver var1, String var2) throws RepositoryException;

    private boolean indexIncomplete(ResourceResolver resolver, Resource contentRoot) throws RepositoryException {
        long indexSize = this.getIndexSize(resolver, contentRoot.getPath());
        NestedBucketStorageSystem storage = contentRoot.adaptTo(NestedBucketStorageSystem.class);
        storage.setBucketPostfix(this.getTopLevelPrefix());
        long nodeCount = storage.getNumberChildren();
        return indexSize != nodeCount;
    }

    private void findReindexPaths(ResourceResolver resolver, Node folder, List<String> results, String componentPathProp) throws RepositoryException {
        NodeIterator children = folder.getNodes();
        while (children.hasNext()) {
            Node child = (Node)children.next();
            if (!child.hasProperty("jcr:primaryType")) continue;
            String primaryType = child.getProperty("jcr:primaryType").getString();
            if ("cq:Page".equals(primaryType) || "sling:Folder".equals(primaryType)) {
                this.findReindexPaths(resolver, child, results, componentPathProp);
                continue;
            }
            if (!"jcr:content".equals(child.getName())) continue;
            NodeIterator contentChildren = child.getNodes();
            while (contentChildren.hasNext()) {
                String commentSystemPath;
                Resource commentSystem;
                Node contentChild = (Node)contentChildren.next();
                if (!contentChild.hasProperty(componentPathProp) || (commentSystem = resolver.getResource(commentSystemPath = contentChild.getProperty(componentPathProp).getString())) == null || !this.checkResource(commentSystem) || child.hasNode(commentSystem.getName() + "_" + "index") && !this.indexIncomplete(resolver, resolver.getResource(contentChild.getPath()))) continue;
                results.add(commentSystemPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindex(String path, int throttle, ResourceResolverFactory resolverFactory, SlingRepository repository) throws Exception {
        Session adminSession = null;
        ResourceResolver resolver = null;
        try {
            adminSession = repository.loginAdministrative(null);
            resolver = resolverFactory.getAdministrativeResourceResolver(null);
            Resource commentSystem = resolver.getResource(path);
            if (commentSystem == null) {
                return;
            }
            if (!this.checkResource(commentSystem)) {
                return;
            }
            log.info("Reindexing " + path);
            String ugcPath = this.getUGCPath(commentSystem);
            String indexBasePath = IndexUtil.getBaseIndexFolder(resolver, ugcPath);
            Resource indexRoot = resolver.getResource(indexBasePath);
            if (indexRoot != null) {
                Node indexRootNode = indexRoot.adaptTo(Node.class);
                indexRootNode.remove();
            }
            Resource contentRoot = resolver.getResource(ugcPath);
            this.reindex(throttle, 0, contentRoot, this.getTopLevelPrefix());
            indexRoot = resolver.getResource(indexBasePath);
            log.info("Completed reindexing " + path);
        }
        catch (LoginException e) {
            log.error("LoginException while reindexing " + path, (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error("RepositoryException while reindexing " + path, (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    private void reindex(int throttle, int count, Resource root, String postfix) throws Exception {
        NestedBucketStorageSystem storageSystem = root.adaptTo(NestedBucketStorageSystem.class);
        storageSystem.setBucketPostfix(postfix);
        Iterator<Resource> iter = storageSystem.listChildren();
        while (iter.hasNext()) {
            if (count > 0 && count % 100 == 0) {
                log.info("Reindexed " + count + " resources.");
            }
            if (count > 0 && count % throttle == 0) {
                Thread.sleep(1000L);
            }
            Resource r = iter.next();
            this.indexExec(root.getResourceResolver(), r.getPath());
            this.reindex(throttle, ++count, r, this.getLowerLevelPrefix());
        }
    }

    class WorkerThread
    implements Runnable {
        WorkerThread() {
        }

        @Override
        public void run() {
            AbstractBaseReindexer.this.performReindexing();
        }
    }
}

