/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.commons.client.api.BaseSocialComponent;
import com.adobe.cq.social.commons.client.api.ClientUtilities;
import com.adobe.cq.social.tally.Rating;
import com.adobe.cq.social.tally.RatingComponent;
import com.adobe.cq.social.tally.Response;
import com.adobe.cq.social.tally.ResponseValue;
import com.adobe.cq.social.tally.TallyException;
import com.adobe.cq.social.tally.client.api.RatingSocialComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public abstract class AbstractRating
extends BaseSocialComponent
implements RatingSocialComponent {
    private final RatingComponent rating;
    protected final Resource resource;
    private final String currentUser;
    private List<String[]> ratingResults;
    protected String[] allowedResponses = new String[]{"5.0", "4.0", "3.0", "2.0", "1.0"};

    public AbstractRating(Resource resource) {
        this(resource.adaptTo(RatingComponent.class), null);
    }

    public AbstractRating(Resource resource, ClientUtilities clientUtils) {
        this(resource.adaptTo(RatingComponent.class), clientUtils);
    }

    public AbstractRating(RatingComponent ratingComponent, ClientUtilities clientUtils) {
        super(ratingComponent.getTallyTarget(), clientUtils);
        this.resource = ratingComponent.getTallyTarget();
        this.rating = ratingComponent;
        this.currentUser = this.resource.getResourceResolver().getUserID();
    }

    @Override
    public String getName() {
        return this.rating.getName();
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return this.rating.getTotalNumberOfResponses();
    }

    @Override
    public ResponseValue getCurrentUserResponse() throws TallyException {
        try {
            Response resp = this.rating.getUserResponse(this.currentUser);
            if (resp == null) {
                return null;
            }
            return resp.getResponseValue();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public Map<String, Long> getResponseTallies() {
        HashMap<String, Long> local = new HashMap<String, Long>();
        Map responses = this.rating.getResponseTallies();
        for (Map.Entry entry : responses.entrySet()) {
            local.put(((Rating)entry.getKey()).getResponseValue(), entry.getValue());
        }
        return local;
    }

    public void addResponse(String value) {
        try {
            this.rating.setUserResponse(this.currentUser, value);
        }
        catch (TallyException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void removeCurrentUserResponse() {
        try {
            this.rating.unsetUserResponse(this.currentUser);
        }
        catch (TallyException e) {
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public Float getAverageRating() {
        return this.rating.getAverageRating();
    }

    @Override
    public String getFormattedAverageRating() {
        return String.format("%.2f", this.rating.getAverageRating());
    }

    @Override
    public List<String[]> getRatingResults() {
        if (null == this.ratingResults) {
            this.buildRatingResults();
        }
        return this.ratingResults;
    }

    private void buildRatingResults() {
        Map<String, Long> responseTallies = this.getResponseTallies();
        this.ratingResults = new ArrayList<String[]>(this.allowedResponses.length);
        for (String allowedResponse : this.allowedResponses) {
            String[] values = new String[]{"0", "0", "0", allowedResponse.substring(0, allowedResponse.indexOf("."))};
            if (responseTallies.containsKey(allowedResponse) && this.getTotalNumberOfResponses() > 0L) {
                values[0] = Long.toString(responseTallies.get(allowedResponse));
                values[1] = Float.toString(responseTallies.get(allowedResponse).floatValue() / (float)this.getTotalNumberOfResponses().longValue());
                values[2] = Float.toString(responseTallies.get(allowedResponse).floatValue() * 100.0f / (float)this.getTotalNumberOfResponses().longValue());
                this.ratingResults.add(values);
                continue;
            }
            this.ratingResults.add(values);
        }
    }

    @Override
    public boolean getCanUserRespond() {
        return this.rating.canUserRespond();
    }

    protected RatingComponent getRatingComponent() {
        return this.rating;
    }
}

