/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.ugcbase;

import com.adobe.cq.social.ugcbase.AttachmentDataSource;
import com.adobe.cq.social.ugcbase.FileDataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.request.RequestParameter;

public class FileUploadSizeLimit {
    private final long attachmentSizeLimit;
    private final long imageSizeLimit;
    private static final String[] imagesContentType = new String[]{".png", ".jpg", ".jpeg", ".gif"};

    public FileUploadSizeLimit(long attachmentSizeLimit, long imageSizeLimit) {
        this.attachmentSizeLimit = attachmentSizeLimit;
        this.imageSizeLimit = imageSizeLimit;
    }

    public boolean fits(RequestParameter fileRequestParameter) {
        AttachmentDataSource attachmentDataSource = new AttachmentDataSource(fileRequestParameter);
        return this.fits(attachmentDataSource);
    }

    public boolean fits(FileDataSource attachmentDataSource) {
        String contentType = attachmentDataSource.getType();
        long contentSize = attachmentDataSource.getSize();
        if (contentSize < 0L) {
            return false;
        }
        if (ArrayUtils.contains((Object[])imagesContentType, (Object)contentType)) {
            return contentSize <= this.imageSizeLimit;
        }
        return contentSize <= this.attachmentSizeLimit;
    }
}

