/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.auth.saml.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Siphon {
    private int bufferSize;
    private boolean closeStreams;

    public Siphon() {
        this(true);
    }

    public Siphon(boolean closeStreams) {
        this(closeStreams, 8192);
    }

    public Siphon(boolean closeStreams, int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be greater than 0");
        }
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void siphon(InputStream in, OutputStream out) throws IOException {
        if (null == in) {
            throw new IllegalArgumentException("InputStream is required.");
        }
        if (null == out) {
            throw new IllegalArgumentException("OutputStream is required.");
        }
        try {
            int read;
            byte[] buffer = new byte[this.bufferSize];
            while (-1 != (read = in.read(buffer))) {
                out.write(buffer, 0, read);
            }
        }
        finally {
            if (this.closeStreams) {
                try {
                    in.close();
                }
                catch (IOException e) {}
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

