/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.comments;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.granite.comments.AbstractComment;
import com.adobe.granite.comments.AbstractCommentingProvider;
import com.adobe.granite.comments.Comment;
import com.adobe.granite.comments.CommentCollection;
import com.adobe.granite.comments.CommentException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConsumerType
public abstract class AbstractCommentCollection<C extends Comment>
implements CommentCollection<C> {
    private List<C> comments = null;
    private final Resource target;
    private final Resource collection;
    private final AbstractCommentingProvider provider;

    protected AbstractCommentCollection(Resource target, Resource collection, AbstractCommentingProvider provider) {
        this.target = target;
        this.collection = collection;
        this.provider = provider;
    }

    @Override
    public final C addComment(String message, String author, String annotationData) throws CommentException {
        if (StringUtils.isBlank((String)message)) {
            throw new IllegalArgumentException("message may not be blank");
        }
        return this.createComment(this.provider.createCommentResource(this.getResource(), message, author, annotationData));
    }

    @Override
    public final List<C> getCommentList() {
        if (null == this.comments) {
            this.comments = new ArrayList<C>();
            Iterator<Resource> resources = this.provider.getCommentResources(this.getResource());
            while (resources.hasNext()) {
                C comment = this.createComment(resources.next());
                this.comments.add(comment);
            }
        }
        return Collections.unmodifiableList(this.comments);
    }

    @Override
    public final Calendar getCreated() {
        return (Calendar)((Object)this.getResource().adaptTo(ValueMap.class).get("jcr:created", Calendar.class));
    }

    @Override
    public final Calendar getLastModified() {
        return (Calendar)((Object)this.getResource().adaptTo(ValueMap.class).get("jcr:lastModified", Calendar.class));
    }

    @Override
    public final String getPath() {
        return this.getResource().getPath();
    }

    @Override
    public final Resource getTarget() {
        return this.target;
    }

    @Override
    public final void remove() {
        this.provider.removeCollectionResource(this.getResource());
    }

    protected final void removeComment(AbstractComment comment) throws CommentException {
        this.provider.removeCommentResource(comment.getResource());
        this.comments = null;
    }

    protected final Resource getResource() {
        return this.collection;
    }

    protected final AbstractCommentingProvider getProvider() {
        return this.provider;
    }

    protected abstract C createComment(Resource var1);
}

