/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.comments;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommentingEvent {
    public static final String EVENT_TOPIC_BASE = "com/adobe/granite/comments";
    private static final String PROPERTY_COMMENT_PATH = "commentPath";
    private final String eventTopic;
    private final String commentPath;

    private CommentingEvent(Event event) {
        this.eventTopic = event.getTopic();
        this.commentPath = event.getProperty(PROPERTY_COMMENT_PATH) instanceof String ? (String)event.getProperty(PROPERTY_COMMENT_PATH) : null;
    }

    public CommentingEvent(Type eventTopic, String commentPath) {
        this.eventTopic = "com/adobe/granite/comments/" + eventTopic.name().toLowerCase();
        this.commentPath = commentPath;
    }

    public static CommentingEvent fromEvent(Event event) {
        String eventType;
        String topic = event.getTopic();
        if (topic.substring(0, EVENT_TOPIC_BASE.length()).equalsIgnoreCase(EVENT_TOPIC_BASE) && Type.valueOf((eventType = topic.substring(EVENT_TOPIC_BASE.length() + 1)).toUpperCase()) == Type.COMMENTED) {
            return new CommentingEvent(event);
        }
        return null;
    }

    public String getCommentPath() {
        return this.commentPath;
    }

    public String getEventTopic() {
        return this.eventTopic.toLowerCase();
    }

    public static CommentingEvent commented(String commentPath) {
        return new CommentingEvent(Type.COMMENTED, commentPath);
    }

    public Event toEvent() {
        return new Event(this.eventTopic, this.getEventProperties());
    }

    private Dictionary<String, Object> getEventProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        if (this.commentPath != null) {
            properties.put(PROPERTY_COMMENT_PATH, this.commentPath);
        }
        return properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        COMMENTED;

    }
}

