/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ocs.api.goals;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.ocs.api.Environment;
import com.adobe.granite.ocs.api.OCSConfig;
import com.adobe.granite.ocs.api.OCSException;
import com.adobe.granite.ocs.api.OCSManager;
import com.adobe.granite.ocs.api.goals.Goal;
import com.adobe.granite.ocs.api.goals.GoalJobProperties;
import java.util.HashMap;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
@Component(componentAbstract=true)
public abstract class AbstractGoal
implements JobConsumer,
Goal {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    @Reference
    private OCSConfig ocsConfig = null;
    private boolean async;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobConsumer.JobResult process(Job job) {
        JobConsumer.JobResult result;
        block13: {
            ResourceResolver resolver = null;
            try {
                String envPath = this.getEnvironmentPath(job);
                resolver = this.getResourceResolver();
                OCSManager ocsManager = resolver.adaptTo(OCSManager.class);
                Environment environment = this.getEnvironment(resolver, envPath);
                this.log.debug("Running goal [{}] with environment [{}]", (Object)job.getTopic(), (Object)environment.getPath());
                try {
                    this.run(job, environment, resolver);
                    if (this.async) {
                        result = JobConsumer.JobResult.ASYNC;
                        break block13;
                    }
                    ocsManager.lifeCycleNext(environment, job.getTopic());
                    result = JobConsumer.JobResult.OK;
                }
                catch (OCSException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    ocsManager.lifeCycleFailed(environment, job.getTopic(), e.getMessage());
                    result = JobConsumer.JobResult.CANCEL;
                }
            }
            catch (LoginException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result = JobConsumer.JobResult.CANCEL;
            }
            catch (OCSException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result = JobConsumer.JobResult.CANCEL;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result = JobConsumer.JobResult.CANCEL;
            }
            finally {
                if (null != resolver) {
                    resolver.close();
                }
            }
        }
        return result;
    }

    protected String getEnvironmentPath(Job job) throws OCSException {
        String envPath = job.getProperty(GoalJobProperties.ENVIRONMENT_PATH.propertyName(), "");
        if (StringUtils.isBlank((String)envPath)) {
            throw new OCSException("environment path not set on job payload");
        }
        return envPath;
    }

    protected Environment getEnvironment(ResourceResolver resolver, String environmentPath) throws OCSException {
        Resource resource;
        if (StringUtils.isBlank((String)environmentPath)) {
            throw new OCSException("environment path must not be empty");
        }
        Environment environment = null;
        if (resolver != null && StringUtils.isNotBlank((String)environmentPath) && (resource = resolver.getResource(environmentPath)) != null) {
            environment = resource.adaptTo(Environment.class);
        }
        if (environment == null) {
            throw new OCSException("not able get and adapt to environment of " + environmentPath);
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceResolver getResourceResolver() throws LoginException, OCSException {
        ResourceResolver ocsLifeCycleResolver = null;
        ResourceResolver adminResolver = null;
        try {
            adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            String ocsLifeCycleUser = this.ocsConfig.getOCSLifecycleUser();
            HashMap<String, Object> authenticationInfo = new HashMap<String, Object>();
            authenticationInfo.put("user.jcr.session", adminResolver.adaptTo(Session.class));
            authenticationInfo.put("user.impersonation", ocsLifeCycleUser);
            ocsLifeCycleResolver = this.resolverFactory.getResourceResolver(authenticationInfo);
        }
        finally {
            if (adminResolver != null) {
                adminResolver.close();
            }
        }
        if (ocsLifeCycleResolver == null) {
            throw new OCSException("error getting ocs system user resolver");
        }
        return ocsLifeCycleResolver;
    }

    protected void setAsync(boolean async) {
        this.async = async;
    }

    protected OCSConfig getOcsConfig() {
        return this.ocsConfig;
    }

    public abstract void run(Job var1, Environment var2, ResourceResolver var3) throws OCSException;

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    protected void bindOcsConfig(OCSConfig oCSConfig) {
        this.ocsConfig = oCSConfig;
    }

    protected void unbindOcsConfig(OCSConfig oCSConfig) {
        if (this.ocsConfig == oCSConfig) {
            this.ocsConfig = null;
        }
    }
}

