/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationException;
import com.adobe.granite.translation.api.TranslationService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranslationService
implements TranslationService {
    private static final Logger log = LoggerFactory.getLogger(AbstractTranslationService.class);
    protected ResourceResolver resolver;
    protected TranslationService.TranslationServiceInfo translationInfo;
    protected TranslationConfig tc;
    protected String defaultCategory;
    protected Map<String, String> availableLanguageMap;
    protected Map<String, String> availableCategoryMap;

    protected AbstractTranslationService(Resource resource, Map<String, String> availableLanguageMap, Map<String, String> availableCategoryMap, String name, String label, String attribution, TranslationConfig tc) {
        log.trace("Starting Constructor for: AbstractTranslationService");
        if (resource != null) {
            this.resolver = resource.getResourceResolver();
        } else {
            log.debug("Resource passed via constructor call was null.");
            this.resolver = null;
        }
        this.tc = tc;
        this.availableLanguageMap = availableLanguageMap;
        this.availableCategoryMap = availableCategoryMap;
        this.translationInfo = new TranslationServiceInfoImpl(name, label, attribution);
    }

    @Override
    public TranslationService.TranslationServiceInfo getTranslationServiceInfo() {
        return this.translationInfo;
    }

    @Override
    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public void setDefaultCategory(String defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    protected boolean validateLanguageCode(String langCode) throws TranslationException {
        log.debug("In function: validateLanguageCode");
        for (String languageKey : this.tc.getLanguages().keySet()) {
            if (!StringUtils.equalsIgnoreCase((String)langCode, (String)languageKey)) continue;
            return true;
        }
        return false;
    }

    public class TranslationServiceInfoImpl
    implements TranslationService.TranslationServiceInfo {
        private String attribution;
        private String translationServiceName;
        private String translationServiceLabel;

        TranslationServiceInfoImpl(String name, String label, String attribution) {
            this.attribution = attribution;
            this.translationServiceName = name;
            this.translationServiceLabel = label;
        }

        @Override
        public String getTranslationServiceAttribution() {
            log.trace("Starting function: getAttribution");
            return this.attribution;
        }

        @Override
        public String getTranslationServiceLabel() {
            log.trace("Starting function: getTranslationServiceLabel");
            return this.translationServiceLabel;
        }

        @Override
        public String getTranslationServiceName() {
            log.trace("Starting function: getTranslationServiceName");
            return this.translationServiceName;
        }
    }
}

