/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.Locale;
import javax.servlet.jsp.PageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionHelper {
    private ExpressionResolver resolver;
    private PageContext pageContext;

    public ExpressionHelper(ExpressionResolver resolver, PageContext pageContext) {
        this.resolver = resolver;
        this.pageContext = pageContext;
    }

    public String getString(String expression) {
        return this.get(expression, String.class);
    }

    public String getString(String expression, Locale locale) {
        return this.get(expression, locale, String.class);
    }

    public boolean getBoolean(String expression) {
        return this.get(expression, Boolean.class);
    }

    public boolean getBoolean(String expression, Locale locale) {
        return this.get(expression, locale, Boolean.class);
    }

    public <T> T get(String expression, Class<T> expectedType) {
        return this.get(expression, this.pageContext.getRequest().getLocale(), expectedType);
    }

    public <T> T get(String expression, Locale locale, Class<T> expectedType) {
        if (expression == null) {
            return null;
        }
        return this.resolver.resolve(expression, locale, expectedType, this.pageContext);
    }
}

