/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import com.adobe.granite.ui.components.Config;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutBuilder {
    private static final String NAME = "name";
    private static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    private JSONObject result = new JSONObject();
    private String resourceType;

    public static LayoutBuilder from(Config config) throws Exception {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT));
    }

    public static LayoutBuilder from(Config config, String defaultResourceType) throws Exception {
        return LayoutBuilder.from(config.getChild(Config.LAYOUT), defaultResourceType);
    }

    public static LayoutBuilder from(Resource resource) throws Exception {
        return LayoutBuilder.from(resource, null);
    }

    public static LayoutBuilder from(Resource resource, String defaultResourceType) throws Exception {
        LayoutBuilder b = new LayoutBuilder();
        ValueMap vm = ResourceUtil.getValueMap(resource);
        b.add(vm);
        b.setResourceType(vm.get(SLING_RESOURCE_TYPE, defaultResourceType));
        return b;
    }

    public boolean hasName() {
        return this.result.has(NAME);
    }

    public String getName() {
        return this.result.optString(NAME, null);
    }

    public void setName(String name) {
        try {
            this.result.put(NAME, name);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void add(String key, Object value) throws Exception {
        this.result.accumulate(key, value);
    }

    public void add(Map<String, Object> data) throws Exception {
        for (Map.Entry<String, Object> e : data.entrySet()) {
            String key = e.getKey();
            if (key.indexOf(":") >= 0) continue;
            this.result.accumulate(key, e.getValue());
        }
    }

    public JSONObject toJSON() {
        return this.result;
    }
}

