/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.core;

import com.adobe.xmp.core.XMPDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class XMPDateTimeUtils {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static XMPDateTime getCurrentDateTime() {
        return new XMPDateTime(new GregorianCalendar());
    }

    public static XMPDateTime convertToLocalTimeZone(XMPDateTime dateTime, boolean adjustTime) {
        if (adjustTime) {
            long timeInMillis = dateTime.getCalendar().getTimeInMillis();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(timeInMillis);
            return new XMPDateTime(cal);
        }
        Calendar cal = dateTime.getCalendar();
        cal.setTimeZone(TimeZone.getDefault());
        return new XMPDateTime(cal);
    }

    public static XMPDateTime convertToUTCTime(XMPDateTime dateTime) {
        long timeInMillis = dateTime.getCalendar().getTimeInMillis();
        GregorianCalendar cal = new GregorianCalendar(UTC);
        cal.setGregorianChange(new Date(Long.MIN_VALUE));
        cal.setTimeInMillis(timeInMillis);
        return new XMPDateTime(cal);
    }
}

