/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.core;

import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.impl.XMPMetadataImpl;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMPMetadataFactory {
    private static String versionString = null;

    public static XMPMetadata create() {
        return new XMPMetadataImpl();
    }

    public static String getVersionString() {
        if (versionString == null) {
            try {
                Enumeration<URL> resources = XMPMetadataFactory.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resources.hasMoreElements()) {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    Attributes attrs = manifest.getMainAttributes();
                    if (!"com.adobe.xmp.core".equals(attrs.getValue("Bundle-SymbolicName")) || attrs.getValue("Bundle-Version") == null) continue;
                    String bundleVersion = attrs.getValue("Bundle-Version");
                    Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+).*");
                    Matcher matcher = pattern.matcher(bundleVersion);
                    if (!matcher.find()) continue;
                    versionString = bundleVersion;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return versionString;
    }
}

