/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.rng.model;

import java.util.HashMap;
import java.util.Map;

public class DatatypeInfo {
    static final Map<String, String> kXMLDatatypes = new HashMap<String, String>();
    private final String mName;
    private final boolean mRaw;

    public DatatypeInfo(String name) {
        this.mName = this.getModelTypeName(name);
        this.mRaw = false;
    }

    public DatatypeInfo(String name, boolean raw) {
        if (raw) {
            if (!kXMLDatatypes.containsKey(name)) {
                this.mName = "Text";
                this.mRaw = false;
            } else {
                this.mName = this.getModelTypeName(name);
                this.mRaw = raw;
            }
        } else {
            this.mName = this.getModelTypeName(name);
            this.mRaw = raw;
        }
    }

    public String getName() {
        return this.mName;
    }

    public boolean isRawType() {
        return this.mRaw;
    }

    private String getModelTypeName(String name) {
        String ret = name;
        if (!kXMLDatatypes.containsValue(name) && kXMLDatatypes.containsKey(name)) {
            ret = kXMLDatatypes.get(name);
        }
        return ret;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("(Name : ").append(this.mName).append(") ");
        return str.toString();
    }

    static {
        kXMLDatatypes.put("text", "Text");
        kXMLDatatypes.put("string", "Text");
        kXMLDatatypes.put("boolean", "Boolean");
        kXMLDatatypes.put("float", "Real");
        kXMLDatatypes.put("double", "Real");
        kXMLDatatypes.put("decimal", "Real");
        kXMLDatatypes.put("integer", "Integer");
        kXMLDatatypes.put("long", "Integer");
        kXMLDatatypes.put("int", "Integer");
        kXMLDatatypes.put("short", "Integer");
        kXMLDatatypes.put("byte", "Integer");
        kXMLDatatypes.put("float", "Real");
        kXMLDatatypes.put("float", "Real");
        kXMLDatatypes.put("float", "Real");
    }
}

