/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.rng.parser;

import com.adobe.xmp.schema.model.SchemaDescription;
import com.adobe.xmp.schema.model.XMPSchemaException;
import com.adobe.xmp.schema.rng.model.PropertyInfo;
import com.adobe.xmp.schema.rng.model.SchemaInfo;
import com.adobe.xmp.schema.rng.parser.SchemaGenerationHandler;
import com.adobe.xmp.schema.rng.parser.annotation.AnnotationsFactory;
import com.adobe.xmp.schema.rng.parser.annotation.RNGAnnotation;
import com.adobe.xmp.schema.rng.parser.annotation.RNGSchemaAnnotation;
import com.adobe.xmp.schema.rng.parser.exceptions.RNGInvalidSchemaException;
import com.adobe.xmp.schema.rng.parser.exceptions.RNGParseException;
import com.adobe.xmp.schema.rng.parser.generator.XMPSchemaGenerator;
import com.adobe.xmp.schema.rng.parser.traverser.GrammarWalker;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.rngom.rngparser.ast.builder.BuildException;
import org.kohsuke.rngom.rngparser.ast.builder.SchemaBuilder;
import org.kohsuke.rngom.rngparser.ast.util.CheckingSchemaBuilder;
import org.kohsuke.rngom.rngparser.digested.DAnnotation;
import org.kohsuke.rngom.rngparser.digested.DGrammarPattern;
import org.kohsuke.rngom.rngparser.digested.DPatternVisitor;
import org.kohsuke.rngom.rngparser.digested.DSchemaBuilderImpl;
import org.kohsuke.rngom.rngparser.parse.IllegalSchemaException;
import org.kohsuke.rngom.rngparser.parse.xml.SAXParseable;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RelaxNGDataModel {
    private GrammarWalker visitor;
    private DGrammarPattern grammar;

    private RelaxNGDataModel(DGrammarPattern grammar) throws RNGParseException {
        this.grammar = grammar;
        this.visitor = new GrammarWalker(grammar);
    }

    private static DGrammarPattern constructGrammar(InputSource is, EntityResolver er, ErrorHandler eh) throws RNGInvalidSchemaException {
        SAXParseable p = new SAXParseable(is, eh, er);
        CheckingSchemaBuilder sb = new CheckingSchemaBuilder((SchemaBuilder)new DSchemaBuilderImpl(), eh);
        DGrammarPattern grammar = null;
        try {
            grammar = (DGrammarPattern)p.parse((SchemaBuilder)sb);
        }
        catch (BuildException e) {
            throw new RNGParseException("Exception occured while parsing input RelaxNG schema", e);
        }
        catch (IllegalSchemaException e) {
            throw new RNGInvalidSchemaException(e);
        }
        return grammar;
    }

    public static RelaxNGDataModel newInstance(URI rngFile, EntityResolver er) throws RNGParseException, RNGInvalidSchemaException, MalformedURLException, IOException {
        DefaultHandler eh = new DefaultHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        };
        return RelaxNGDataModel.newInstance(rngFile, er, (ErrorHandler)eh);
    }

    public static RelaxNGDataModel newInstance(URI rngFile, EntityResolver er, ErrorHandler eh) throws RNGInvalidSchemaException, MalformedURLException, IOException {
        InputSource is = new InputSource(rngFile.toURL().openStream());
        return RelaxNGDataModel.newInstance(is, er, eh);
    }

    public static RelaxNGDataModel newInstance(InputSource is, EntityResolver er) throws RNGInvalidSchemaException {
        DefaultHandler eh = new DefaultHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        };
        return RelaxNGDataModel.newInstance(is, er, (ErrorHandler)eh);
    }

    public static RelaxNGDataModel newInstance(InputSource is, EntityResolver er, ErrorHandler eh) throws RNGInvalidSchemaException {
        DGrammarPattern grammar = RelaxNGDataModel.constructGrammar(is, er, eh);
        return new RelaxNGDataModel(grammar);
    }

    public SchemaDescription constructXMPSchema(SchemaGenerationHandler handler) throws RNGParseException, XMPSchemaException {
        if (handler == null) {
            throw new IllegalArgumentException("ISchemaGenerationTraceHandler used for constructing schemas should not be null");
        }
        this.visitor.setSchemaGenerationHandler(handler);
        this.grammar.accept((DPatternVisitor)this.visitor);
        ArrayList propInfoList = this.visitor.getPropInfoList();
        if (propInfoList == null || propInfoList.size() == 0) {
            throw new RNGParseException("Schema files defined a schema without any properties.");
        }
        PropertyInfo firstProperty = (PropertyInfo)propInfoList.get(0);
        SchemaInfo info = firstProperty.getSchemaInfo();
        handler.startSchemaConstruction(firstProperty.getNS(), info.getPrefix());
        this.handleAnnotation(info, 0);
        XMPSchemaGenerator rngGenerator = new XMPSchemaGenerator(firstProperty.getNS(), info.getLabel(), info.getDescription(), propInfoList);
        return rngGenerator.getModel();
    }

    private void handleAnnotation(SchemaInfo schemaInfo, int index) {
        DAnnotation annot = this.grammar.getAnnotation();
        if (annot == null) {
            return;
        }
        List elements = annot.getChildren();
        if (elements == null || index >= elements.size()) {
            return;
        }
        RNGAnnotation rngAnnot = AnnotationsFactory.createAnnotation((Element)((Element)elements.get(index)));
        if (rngAnnot == null) {
            return;
        }
        if (rngAnnot instanceof RNGSchemaAnnotation) {
            ((RNGSchemaAnnotation)rngAnnot).setAnnotationData(schemaInfo);
        }
    }
}

