/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.schema.service;

import com.adobe.xmp.path.XMPPath;
import com.adobe.xmp.schema.service.RelaxNGProvider;
import com.adobe.xmp.schema.service.SchemaServiceException;
import com.adobe.xmp.schema.service.impl.SchemaManifestParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardRelaxNGProvider
implements RelaxNGProvider {
    private static final String DEFAULT_MANIFEST_FILE = "relaxng/schemaManifest.xml";
    private List<URI> includePaths;
    private Map<String, URI> schemaMap;

    public StandardRelaxNGProvider() throws SchemaServiceException {
        this(null);
    }

    StandardRelaxNGProvider(URI schemaManifestURI) throws SchemaServiceException {
        try {
            if (schemaManifestURI == null) {
                schemaManifestURI = StandardRelaxNGProvider.getResource(DEFAULT_MANIFEST_FILE);
            }
            SchemaManifestParser.SchemaManifest manifest = SchemaManifestParser.parse((URI)schemaManifestURI);
            this.schemaMap = new HashMap<String, URI>();
            for (String schemaURI : manifest.schemaFiles.keySet()) {
                String path = (String)manifest.schemaFiles.get(schemaURI);
                this.schemaMap.put(schemaURI, StandardRelaxNGProvider.getResource(path));
            }
            this.includePaths = new ArrayList<URI>();
            for (String includePath : manifest.includePaths) {
                this.includePaths.add(StandardRelaxNGProvider.getResource(includePath));
            }
        }
        catch (Exception e) {
            throw new SchemaServiceException(e.getMessage(), e);
        }
    }

    @Override
    public InputStream getSchema(String namespaceURI) throws IOException {
        URI filePath = this.schemaMap.get(namespaceURI);
        if (filePath != null) {
            URL url = filePath.toURL();
            return url.openStream();
        }
        return null;
    }

    @Override
    public InputStream getInclude(String includeName) throws IOException {
        InputStream is = null;
        try {
            for (URI path : this.includePaths) {
                URI includePath = new URI(path + includeName);
                URL url = includePath.toURL();
                try {
                    is = url.openStream();
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        return is;
    }

    @Override
    public boolean isAvailable(String namespaceURI) {
        return this.schemaMap.containsKey(namespaceURI);
    }

    @Override
    public Set<String> getNamespaces() {
        return this.schemaMap.keySet();
    }

    private static ClassLoader getClassLoader() {
        ClassLoader loader = StandardRelaxNGProvider.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    private static URI getResource(String path) throws URISyntaxException {
        ClassLoader loader = StandardRelaxNGProvider.getClassLoader();
        return loader.getResource(path).toURI();
    }

    @Override
    public Map<XMPPath, Map<QName, Map<String, String>>> getRuntimeDecorators() {
        return null;
    }
}

