/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst;

import com.day.cq.analytics.sitecatalyst.ImpressionsEntry;
import com.day.cq.analytics.sitecatalyst.SitecatalystException;
import com.day.cq.analytics.sitecatalyst.SitecatalystUtil;
import com.day.cq.analytics.sitecatalyst.SitecatalystWebservice;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Dictionary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%cq.analytics.sitecatalyst.importer.name", description="%cq.analytics.sitecatalyst.importer.description")
@Service
@Properties(value={@Property(name="importer.scheme", value={"sitecatalyst"}, propertyPrivate=true)})
public class ImpressionsImporter
implements Importer,
TopologyEventListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(longValue={43200000L})
    protected static final String REPORT_INTERVAL = "cq.analytics.sitecatalyst.importer.inverval";
    private static final long DEFAULT_INTERVAL = 43200000L;
    private long reportInterval;
    @Property(boolValue={true})
    private static final String ENABLED = "cq.analytics.sitecatalyst.importer.enabled";
    private static final boolean DEFAULT_ENABLED = true;
    private boolean enabled;
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private SitecatalystWebservice webservice;
    @Reference
    private StatisticsService statService;
    @Reference
    private ConfigurationManager cfgManager;
    private boolean isMasterInstance = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData(String scheme, String dataSource, Resource target) throws ImportException {
        block38: {
            if (this.enabled) {
                if (!this.isMasterInstance) {
                    this.log.info("Import skipped on slave instance");
                    return;
                }
                try {
                    Resource pageResource = target.getParent().getParent();
                    HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(pageResource);
                    Node analytics = target.getParent().adaptTo(Node.class);
                    String lastAttempt = "0";
                    if (analytics.hasProperty("cq:lastAttempt")) {
                        lastAttempt = analytics.getProperty("cq:lastAttempt").getString();
                    }
                    Configuration configuration = null;
                    String[] services = pageProperties.getInherited("cq:cloudserviceconfigs", new String[0]);
                    if (this.cfgManager != null && services.length > 0) {
                        configuration = this.cfgManager.getConfiguration("sitecatalyst", services);
                    }
                    if (configuration == null) {
                        this.log.error("SiteCatalyst configuration not found");
                        return;
                    }
                    String reportSuiteID = SitecatalystUtil.getReportSuites(this.settingsService, configuration);
                    if (lastAttempt.startsWith("waiting")) {
                        String reportID = lastAttempt.replace("waiting-", "");
                        try {
                            String response = this.webservice.getReportStatus(configuration, reportID);
                            JSONObject jsonObj = new JSONObject(response);
                            if (jsonObj.getString("status").equals("done")) {
                                response = this.webservice.getReport(configuration, reportID);
                                jsonObj = new JSONObject(response);
                                JSONArray data = jsonObj.getJSONObject("report").getJSONArray("data");
                                String lastAttemptDate = analytics.getProperty("cq:lastAttemptDate").getString();
                                String statsBasePath = "/var/statistics/pages" + analytics.getPath().replace("/jcr:content/analytics", "");
                                this.log.info("Report contains data items: " + data.length());
                                for (int i = 0; i < data.length(); ++i) {
                                    JSONObject pageData = data.getJSONObject(i);
                                    this.setStatsData(statsBasePath, lastAttemptDate, pageData.getString("name"), pageData.getJSONArray("counts").getString(0), target.getResourceResolver(), this.statService);
                                }
                                this.log.info("Report " + reportID + " imported");
                            } else if (jsonObj.getString("status").equals("failed")) {
                                String errorMsg = "";
                                if (jsonObj.has("error_msg")) {
                                    errorMsg = jsonObj.getString("error_msg");
                                } else if (jsonObj.has("statusMsg")) {
                                    errorMsg = jsonObj.getString("statusMsg");
                                }
                                this.log.info("Report " + reportID + " failed due to (" + jsonObj.getInt("error_code") + ") " + errorMsg);
                            }
                            break block38;
                        }
                        catch (SitecatalystException e) {
                            this.log.error("Call to Sitecatalyst failed", (Throwable)e);
                            break block38;
                        }
                        catch (JSONException e) {
                            this.log.error("Parsing JSON response failed", (Throwable)e);
                            break block38;
                        }
                        finally {
                            if (analytics.getSession().hasPendingChanges()) {
                                analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                                analytics.getSession().save();
                            }
                        }
                    }
                    long last = Long.parseLong(lastAttempt);
                    if (last + this.reportInterval >= System.currentTimeMillis()) break block38;
                    if (reportSuiteID == null) {
                        this.log.warn("cannot import data since no valid report suite ID was found");
                        return;
                    }
                    try {
                        Calendar cal = Calendar.getInstance();
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                        cal.add(5, -1);
                        String date = dateFormat.format(cal.getTime());
                        String response = this.webservice.queuePageViewReport(configuration, reportSuiteID, date);
                        JSONObject jsonObj = new JSONObject(response);
                        Long reportID = jsonObj.getLong("reportID");
                        if (jsonObj.getString("status").equals("queued")) {
                            analytics.setProperty("cq:lastAttempt", "waiting-" + reportID);
                            analytics.setProperty("cq:lastAttemptDate", date);
                            this.log.info("Report queued: " + reportID + " for " + reportSuiteID + " and " + date);
                        } else {
                            String errorMsg = "";
                            if (jsonObj.has("error_msg")) {
                                errorMsg = jsonObj.getString("error_msg");
                            } else if (jsonObj.has("statusMsg")) {
                                errorMsg = jsonObj.getString("statusMsg");
                            }
                            this.log.warn(jsonObj.toString());
                            this.log.warn("queueing report failed with status '" + jsonObj.getString("status") + "' and error message '" + errorMsg + "'");
                            analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                        }
                    }
                    catch (SitecatalystException e) {
                        this.log.error("Call to SiteCatalyst failed", (Throwable)e);
                        analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                    }
                    catch (JSONException e) {
                        this.log.error("Parsing JSON response failed", (Throwable)e);
                        analytics.setProperty("cq:lastAttempt", Long.toString(System.currentTimeMillis()));
                    }
                    finally {
                        if (analytics.getSession().hasPendingChanges()) {
                            analytics.getSession().save();
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    this.log.error("Reading analytics data failed for " + target.getPath(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    this.log.error("Reading analytics data failed", (Throwable)e);
                }
            }
        }
    }

    private void setStatsData(String basePath, String date, String name, String count, ResourceResolver resolver, StatisticsService statService) {
        ValueMap statsConfig;
        long views;
        String statsPath = basePath;
        name = !name.equals("home") ? "/" + name.replace(":", "/") : "";
        statsPath = statsPath + name + "/.stats/";
        Resource dayStats = resolver.getResource(statsPath = statsPath + date.replace("-", "/"));
        if (dayStats != null && (views = ((Long)((Object)(statsConfig = dayStats.adaptTo(ValueMap.class)).get("views", Long.class))).longValue()) == Long.parseLong(count)) {
            return;
        }
        ImpressionsEntry view = new ImpressionsEntry(basePath, name, date, Long.parseLong(count));
        try {
            statService.addEntry(view);
        }
        catch (RepositoryException e) {
            this.log.error("adding stats entry failed", (Throwable)e);
        }
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary config = componentContext.getProperties();
        this.reportInterval = OsgiUtil.toLong(config.get(REPORT_INTERVAL), 43200000L);
        this.enabled = OsgiUtil.toBoolean(config.get(ENABLED), true);
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (event.getType() == TopologyEvent.Type.TOPOLOGY_CHANGED || event.getType() == TopologyEvent.Type.TOPOLOGY_INIT) {
            this.isMasterInstance = event.getNewView().getLocalInstance().isLeader();
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        this.webservice = sitecatalystWebservice;
    }

    protected void unbindWebservice(SitecatalystWebservice sitecatalystWebservice) {
        if (this.webservice == sitecatalystWebservice) {
            this.webservice = null;
        }
    }

    protected void bindStatService(StatisticsService statisticsService) {
        this.statService = statisticsService;
    }

    protected void unbindStatService(StatisticsService statisticsService) {
        if (this.statService == statisticsService) {
            this.statService = null;
        }
    }

    protected void bindCfgManager(ConfigurationManager configurationManager) {
        this.cfgManager = configurationManager;
    }

    protected void unbindCfgManager(ConfigurationManager configurationManager) {
        if (this.cfgManager == configurationManager) {
            this.cfgManager = null;
        }
    }
}

