/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import com.day.cq.commons.TidyJsonItemWriter;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class SitecatalystJsonItemWriter
extends TidyJsonItemWriter {
    public SitecatalystJsonItemWriter() {
        super(new HashSet<String>());
    }

    protected void dump(Node node, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {
        Node n;
        Property prop;
        boolean isArray = true;
        NodeIterator children = node.getNodes();
        if (!children.hasNext()) {
            isArray = false;
        }
        while (children.hasNext()) {
            Node n2 = children.nextNode();
            if (n2.getName().matches("\\d+")) continue;
            isArray = false;
            break;
        }
        PropertyIterator props = node.getProperties();
        if (isArray && props.hasNext()) {
            while (props.hasNext()) {
                prop = props.nextProperty();
                if (prop.getName().matches("jcr:.+")) continue;
                isArray = false;
                break;
            }
        }
        if (isArray) {
            w.array();
            if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                children = node.getNodes();
                while (children.hasNext()) {
                    n = children.nextNode();
                    this.dump(n, w, currentRecursionLevel + 1, maxRecursionLevels);
                }
            }
            w.endArray();
        } else {
            w.object();
            props = node.getProperties();
            while (props.hasNext()) {
                prop = props.nextProperty();
                if (prop.getName().matches("jcr:.+") || prop.getName().matches("cq:.+")) continue;
                this.writeProperty(w, prop);
            }
            if (this.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                children = node.getNodes();
                while (children.hasNext()) {
                    n = children.nextNode();
                    this.dumpSingleNode(n, w, currentRecursionLevel, maxRecursionLevels);
                }
            }
            w.endObject();
        }
    }
}

