/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.testandtarget;

import com.day.cq.analytics.testandtarget.Conversion;
import com.day.cq.analytics.testandtarget.Step;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recipe {
    public static final String TRAFFIC_TYPE_TESTING = "TESTING";
    public static final String TRAFFIC_TYPE_TOTAL = "TOTAL";
    private final String id;
    private final String name;
    private final String trafficType;
    private final Conversion conversion;
    private final List<Step> steps = new ArrayList<Step>();

    public Recipe(String id, String name, String trafficType, Conversion conversion) {
        this.id = id;
        this.name = name;
        this.trafficType = trafficType;
        this.conversion = conversion;
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTrafficType() {
        return this.trafficType;
    }

    public Conversion getConversion() {
        return this.conversion;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public int getStepValueByName(String stepName) {
        for (Step step : this.steps) {
            if (!stepName.equals(step.getName())) continue;
            return step.getCount().intValue();
        }
        return 0;
    }

    public int getConversionCount() {
        return this.conversion != null ? this.conversion.getCount().intValue() : 0;
    }
}

