/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.handler;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceInputStream;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.FieldType;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(inherit=true, metatype=true)
@Service
public class StandardImageHandler
extends AbstractAssetHandler {
    protected final Logger log = LoggerFactory.getLogger(StandardImageHandler.class);
    public static final String GIF_MIMETYPE = "image/gif";
    public static final String PNG1_MIMETYPE = "image/png";
    public static final String PNG2_MIMETYPE = "image/x-png";
    public static final String JPEG_MIMETYPE = "image/jpeg";
    public static final String PJPEG_MIMETYPE = "image/pjpeg";
    public static final String TIFF_MIMETYPE = "image/tiff";
    public static final String TIFF1_MIMETYPE = "image/x-tiff";
    public static final String BMP1_MIMETYPE = "image/x-ms-bmp";
    public static final String BMP2_MIMETYPE = "image/bmp";
    public static final String RAW1_MIMETYPE = "image/x-raw-adobe";
    public static final String RAW2_MIMETYPE = "image/x-raw-hasselblad";
    public static final String RAW3_MIMETYPE = "image/x-raw-fuji";
    public static final String RAW4_MIMETYPE = "image/x-raw-canon";
    public static final String RAW5_MIMETYPE = "image/x-raw-kodak";
    public static final String RAW6_MIMETYPE = "image/x-raw-minolta";
    public static final String RAW7_MIMETYPE = "image/x-raw-nikon";
    public static final String RAW8_MIMETYPE = "image/x-raw-olympus";
    public static final String RAW9_MIMETYPE = "image/x-raw-pentax";
    public static final String RAW10_MIMETYPE = "image/x-raw-sony";
    public static final String RAW11_MIMETYPE = "image/x-raw-sigma";
    public static final String RAW12_MIMETYPE = "image/x-raw-epson";
    public static final String RAW13_MIMETYPE = "image/x-raw-mamiya";
    public static final String RAW14_MIMETYPE = "image/x-raw-leaf";
    public static final String RAW15_MIMETYPE = "image/x-raw-panasonic";
    public static final String RAW16_MIMETYPE = "image/x-raw-phaseone";
    public static final String RAW17_MIMETYPE = "image/x-raw-red";
    public static final String RAW18_MIMETYPE = "image/x-raw-imacon";
    public static final String RAW19_MIMETYPE = "image/x-raw-logitech";
    public static final String RAW20_MIMETYPE = "image/x-raw-casio";
    public static final String RAW21_MIMETYPE = "image/x-raw-rawzor";
    public static final String DNG_MIMETYPE = "image/dng";
    protected static final String[] MIME_TYPES = new String[]{"image/gif", "image/png", "image/x-png", "image/tiff", "image/x-tiff", "image/x-ms-bmp", "image/bmp", "image/x-raw-adobe", "image/x-raw-hasselblad", "image/x-raw-fuji", "image/x-raw-canon", "image/x-raw-kodak", "image/x-raw-minolta", "image/x-raw-nikon", "image/x-raw-olympus", "image/x-raw-pentax", "image/x-raw-sony", "image/x-raw-sigma", "image/x-raw-epson", "image/x-raw-mamiya", "image/x-raw-leaf", "image/x-raw-panasonic", "image/x-raw-phaseone", "image/x-raw-red", "image/x-raw-imacon", "image/x-raw-logitech", "image/x-raw-casio", "image/x-raw-rawzor", "image/dng"};
    private static final Set<String> IGNORED_FROM_SANSELAN = new HashSet<String>();
    @Property(boolValue={false})
    protected static final String ENABLE_BINARY_META_EXTRACTION = "cq.dam.enable.ext.meta.extraction";
    protected boolean enableExtMetaExtraction = false;

    @Override
    public String[] getMimeTypes() {
        return MIME_TYPES;
    }

    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        try {
            this.extractMetadata(asset, metadata);
            this.setMimetype(metadata, asset);
        }
        catch (Exception e) {
            this.log.error("extractMetadata: error while extracting metadata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        return metadata;
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension maxDimension) throws IOException {
        block14: {
            InputStream is = null;
            try {
                BufferedImage bufferedImage;
                is = rendition.getStream();
                if (this.isGif(rendition) || this.isPng(rendition) || this.isRaw(rendition)) {
                    BufferedImage bufferedImage2 = new Layer(is, maxDimension).getImage();
                    return bufferedImage2;
                }
                FileOutputStream itout = null;
                FileInputStream iis = null;
                File imageTmpFile = null;
                try {
                    imageTmpFile = File.createTempFile("image", ".tmp");
                    BufferedImage bufImage = Imaging.getBufferedImage((InputStream)is);
                    itout = FileUtils.openOutputStream((File)imageTmpFile);
                    long startTime = System.currentTimeMillis();
                    Imaging.writeImage((BufferedImage)bufImage, (OutputStream)itout, (ImageFormat)ImageFormat.IMAGE_FORMAT_PNG, null);
                    long endTime = System.currentTimeMillis();
                    this.log.debug("time taken to convert to png = " + (endTime - startTime) + " ms");
                    iis = FileUtils.openInputStream((File)imageTmpFile);
                    bufferedImage = new Layer((InputStream)iis, maxDimension).getImage();
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly(itout);
                        FileUtils.deleteQuietly((File)imageTmpFile);
                        throw throwable;
                    }
                    catch (ImageReadException e) {
                        this.log.warn("getImage: error while reading image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block14;
                    }
                    catch (ImageWriteException e) {
                        this.log.warn("getImage: error while writing image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block14;
                    }
                    catch (IOException e) {
                        this.log.warn("getImage: error while reading image at path [{}]: ", (Object)rendition.getPath(), (Object)e);
                        break block14;
                    }
                }
                IOUtils.closeQuietly((InputStream)iis);
                IOUtils.closeQuietly((OutputStream)itout);
                FileUtils.deleteQuietly((File)imageTmpFile);
                return bufferedImage;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Serializable> extractImageInfo(Asset asset) {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        InputStream is = asset.getOriginal().getStream();
        try {
            ByteSourceInputStream bsis = new ByteSourceInputStream(is, null);
            ImageParser imageParser = this.getImageParser((ByteSource)bsis);
            this.extractImageInfo(asset.getPath(), (ByteSource)bsis, imageParser);
        }
        catch (ImageReadException e) {
            this.log.warn("extractImageInfo: error while reading metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        catch (IOException e) {
            this.log.warn("extractImageInfo: error while reading info from image [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return metadata;
    }

    private Map<String, Serializable> extractImageInfo(String path, ByteSource bsis, ImageParser ip) {
        HashMap<String, Serializable> metadata = new HashMap<String, Serializable>();
        try {
            ImageInfo imageInfo = ip.getImageInfo(bsis);
            int numberOfImages = imageInfo.getNumberOfImages();
            if (numberOfImages < 0) {
                numberOfImages = 1;
            }
            metadata.put("File format", (Serializable)((Object)imageInfo.getFormat().getName()));
            metadata.put("MIME type", (Serializable)((Object)imageInfo.getMimeType()));
            metadata.put("Image Width", Integer.valueOf(imageInfo.getWidth()));
            metadata.put("Image Length", Integer.valueOf(imageInfo.getHeight()));
            metadata.put("Bits per pixel", Integer.valueOf(imageInfo.getBitsPerPixel()));
            metadata.put("Progressive", (Serializable)((Object)(imageInfo.isProgressive() ? "yes" : "no")));
            metadata.put("Number of images", Integer.valueOf(numberOfImages));
            metadata.put("Physical width in dpi", Integer.valueOf(imageInfo.getPhysicalWidthDpi()));
            metadata.put("Physical height in dpi", Integer.valueOf(imageInfo.getPhysicalHeightDpi()));
            metadata.put("Physical width in inches", Double.valueOf(imageInfo.getPhysicalWidthInch()));
            metadata.put("Physical height in inches", Double.valueOf(imageInfo.getPhysicalHeightInch()));
            List comments = imageInfo.getComments();
            int numComments = comments == null ? 0 : comments.size();
            metadata.put("Number of textual comments", Integer.valueOf(numComments));
            if (numComments > 0) {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < numComments; ++i) {
                    if (comments == null) continue;
                    buffer.append(comments.get(i)).append('\n');
                }
                metadata.put("Comments", (Serializable)((Object)buffer.toString()));
            }
        }
        catch (ImageReadException e) {
            this.log.warn("extractImageInfo: error while reading metadata from image [{}]: ", (Object)path, (Object)e);
        }
        catch (IOException e) {
            this.log.warn("extractImageInfo: error while reading info from image [{}]: ", (Object)path, (Object)e);
        }
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractMetadata(Asset asset, ExtractedMetadata metadata) throws IOException, ImageReadException {
        InputStream is = asset.getOriginal().getStream();
        IImageMetadata data = null;
        try {
            try {
                ByteSourceInputStream bsis = new ByteSourceInputStream(is, null);
                ImageParser imageParser = this.getImageParser((ByteSource)bsis);
                data = imageParser.getMetadata((ByteSource)bsis);
                if (data != null && data instanceof JpegImageMetadata) {
                    JpegImageMetadata jpegMetadata = (JpegImageMetadata)data;
                    JpegPhotoshopMetadata jpegphotoshopMetadata = jpegMetadata.getPhotoshop();
                    if (jpegphotoshopMetadata != null) {
                        for (IImageMetadata.IImageMetadataItem item : jpegphotoshopMetadata.getItems()) {
                            this.setPhotoshopItemValue(item, metadata);
                        }
                    }
                    data = jpegMetadata.getExif();
                }
                Map<String, Serializable> imageData = this.extractImageInfo(asset.getPath(), (ByteSource)bsis, imageParser);
                metadata.addMetadataProperties(imageData);
                if (data != null && data instanceof TiffImageMetadata) {
                    TiffImageMetadata tiffMetadata = (TiffImageMetadata)data;
                    List allFields = tiffMetadata.getAllFields();
                    for (TiffField tf : allFields) {
                        String tagName = tf.getTagName();
                        FieldType fieldType = tf.getFieldType();
                        if (!(!this.enableExtMetaExtraction && (fieldType.equals(FieldType.BYTE) || fieldType.equals(FieldType.UNDEFINED)) || tagName.equals(TiffTagConstants.TIFF_TAG_XMP.name) || IGNORED_FROM_SANSELAN.contains(tagName))) {
                            this.log.debug("name =" + tagName + ", type=" + tf.getFieldTypeName());
                            metadata.setMetaDataProperty(tagName, this.trimValue(tf));
                            continue;
                        }
                        this.log.debug("Skipping XMP tag [" + tagName + "],  of type [" + fieldType.getName() + "] XMP is scanned by CQ generic XMP scanner", (Object)tagName);
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("extractMetadata: cannot read metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
            }
            if (this.enableExtMetaExtraction) {
                this.extractImageXMP(asset.getOriginal().getStream(), metadata);
            }
            this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
            if (metadata.getXmp() == null && !this.enableExtMetaExtraction) {
                this.extractImageXMP(asset.getOriginal().getStream(), metadata);
            }
        }
        catch (Exception e) {
            this.log.warn("extractMetadata: cannot read metadata from image [{}]: ", (Object)asset.getPath(), (Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void extractImageXMP(InputStream stream, ExtractedMetadata metadata) {
        try {
            String xmpStr = Imaging.getXmpXml((InputStream)stream, null);
            this.log.debug("extracted xmp string is {}", (Object)xmpStr);
            if (xmpStr != null) {
                metadata.setXmp(new ByteArrayInputStream(xmpStr.getBytes("utf-8")));
            }
        }
        catch (Exception e) {
            this.log.error("could not extract XMP from the image", (Throwable)e);
        }
    }

    private void setPhotoshopItemValue(IImageMetadata.IImageMetadataItem item, ExtractedMetadata extractedMetadata) {
        if (item instanceof ImageMetadata.Item) {
            ImageMetadata.Item imageItem = (ImageMetadata.Item)item;
            String keyword = imageItem.getKeyword();
            String text = imageItem.getText();
            extractedMetadata.setMetaDataProperty(keyword, text);
        }
    }

    private ImageParser getImageParser(ByteSource byteSrc) throws ImageReadException, IOException {
        ImageFormat format = Imaging.guessFormat((ByteSource)byteSrc);
        if (!format.equals((Object)ImageFormat.IMAGE_FORMAT_UNKNOWN)) {
            ImageParser[] imageParsers;
            for (ImageParser imageParser : imageParsers = ImageParser.getAllImageParsers()) {
                if (!imageParser.canAcceptType(format)) continue;
                return imageParser;
            }
        }
        throw new ImageReadException("Can't parse this format.");
    }

    private Object trimValue(TiffField field) throws ImageReadException {
        Object fieldValue = field.getValue();
        if (fieldValue instanceof String) {
            fieldValue = StringUtils.trimToEmpty((String)fieldValue.toString());
        }
        return fieldValue;
    }

    private boolean isPng(Rendition rendition) {
        return rendition.getMimeType().startsWith(PNG1_MIMETYPE) || rendition.getMimeType().startsWith(PNG2_MIMETYPE);
    }

    private boolean isGif(Rendition rendition) {
        return rendition.getMimeType().startsWith(GIF_MIMETYPE);
    }

    private boolean isRaw(Rendition rendition) {
        return rendition.getMimeType().startsWith("image/x-raw-");
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
        this.enableExtMetaExtraction = PropertiesUtil.toBoolean(context.getProperties().get(ENABLE_BINARY_META_EXTRACTION), false);
    }

    static {
        IGNORED_FROM_SANSELAN.add("Image Description");
        IGNORED_FROM_SANSELAN.add("Artist");
        IGNORED_FROM_SANSELAN.add("Copyright");
    }
}

