/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.day.cq.commons.LabeledResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Page;
import com.day.text.Text;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIHelper {
    private static final Logger log = LoggerFactory.getLogger(UIHelper.class);
    private static final String[] LAYER_UNSUPPORTED_MIME_TYPES = new String[]{"image/tiff"};
    private static final List<String> LAYER_UNSUPPORTED_MIME_TYPE = Arrays.asList(LAYER_UNSUPPORTED_MIME_TYPES);

    private static boolean isLayerUnSupported(String mimetype) {
        return LAYER_UNSUPPORTED_MIME_TYPE.contains(mimetype);
    }

    public static String getTitle(Resource res) {
        String title = null;
        try {
            Node resNode = res.adaptTo(Node.class);
            if (resNode.isNodeType("dam:Asset")) {
                Node metadata = resNode.getNode("jcr:content/metadata");
                if (metadata != null && metadata.hasProperty("dc:title")) {
                    title = DamUtil.getValue(metadata, "dc:title", "");
                }
            } else if (resNode.isNodeType("cq:Page")) {
                Node contentNode;
                Page page = res.adaptTo(Page.class);
                title = page.getPageTitle();
                if (StringUtils.isBlank((String)title) && resNode.hasNode("jcr:content") && (contentNode = resNode.getNode("jcr:content")).hasProperty("jcr:title")) {
                    title = contentNode.getProperty("jcr:title").getString();
                }
            } else {
                LabeledResource lr = res.adaptTo(LabeledResource.class);
                if (lr != null) {
                    title = lr.getTitle();
                } else if (resNode.hasProperty("jcr:title")) {
                    title = resNode.getProperty("jcr:title").getString();
                }
            }
        }
        catch (Exception ex) {
            log.error("error in get title ", (Throwable)ex);
        }
        if (title != null && !title.equals("")) {
            return title;
        }
        return Text.getName(res.getPath());
    }

    public static Rendition getBestfitRendition(Asset asset, int width) {
        List<Rendition> renditions = asset.getRenditions();
        return DamUtil.getBestFitRendition(width, renditions);
    }

    public static long getCacheKiller(Node node) {
        long ck = 0L;
        try {
            if (node.isNodeType("dam:Asset") || node.isNodeType("nt:file")) {
                if (node.hasProperty("jcr:content/jcr:lastModified")) {
                    ck = node.getProperty("jcr:content/jcr:lastModified").getLong();
                }
            } else if (node.isNodeType("nt:folder") && node.hasProperty("jcr:content/folderThumbnail/jcr:content/jcr:lastModified")) {
                ck = node.getProperty("jcr:content/folderThumbnail/jcr:content/jcr:lastModified").getLong();
            }
        }
        catch (Exception e) {
            log.error("error creating cache killer", (Throwable)e);
        }
        return ck / 1000L * 1000L;
    }

    public static Resource getCurrentSuffixResource(SlingHttpServletRequest request) {
        String contentPath = request.getRequestPathInfo().getSuffix();
        Resource res = request.getResourceResolver().getResource(contentPath);
        if (contentPath == null || !contentPath.contains("/content/dam") || res == null) {
            return request.getResourceResolver().getResource("/content/dam");
        }
        return res;
    }

    public static String getSizeLabel(double size) {
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int i = 0;
        while (size >= 1024.0) {
            size /= 1024.0;
            ++i;
        }
        return (double)Math.round(size * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0) + " " + units[i];
    }

    public static String getSizeLabel(double size, SlingHttpServletRequest slingRequest) {
        Locale locale = slingRequest.getResourceBundle(null).getLocale();
        I18n i18n = new I18n(slingRequest);
        int i = 0;
        while (size >= 1024.0) {
            size /= 1024.0;
            ++i;
        }
        NumberFormat nf = NumberFormat.getInstance(locale);
        String formattedSize = nf.format((double)Math.round(size * Math.pow(10.0, 1.0)) / Math.pow(10.0, 1.0));
        switch (i) {
            case 0: {
                return i18n.get("{0} B", "Byte", formattedSize);
            }
            case 1: {
                return i18n.get("{0} KB", "KiloByte", formattedSize);
            }
            case 2: {
                return i18n.get("{0} MB", "MegaByte", formattedSize);
            }
            case 3: {
                return i18n.get("{0} GB", "GigaByte", formattedSize);
            }
            case 4: {
                return i18n.get("{0} TB", "TeraByte", formattedSize);
            }
        }
        return "";
    }

    public static boolean hasPermission(AccessControlManager acm, Resource res, String privilege) throws RepositoryException {
        Privilege p = acm.privilegeFromName(privilege);
        return acm.hasPrivileges(res.getPath(), new Privilege[]{p});
    }

    public static boolean isEditSupportedFormat(String mimetype) {
        String[] supportedTypes;
        for (String type : supportedTypes = new String[]{"image/jpg", "image/jpeg", "image/png", "image/gif", "image/bmp"}) {
            if (!type.equalsIgnoreCase(mimetype)) continue;
            return true;
        }
        return false;
    }

    public static Rendition getBestFitRendtionBasedOnSize(Asset asset, long size) {
        return UIHelper.getBestFitRendtionBasedOnSize(asset, size, false);
    }

    public static Rendition getBestFitRendtionBasedOnSize(Asset asset, long size, boolean preferOriginal) {
        try {
            long sizeinBytes = size * 1024L;
            List<Rendition> renditions = asset.getRenditions();
            SizeBasedRenditionComparator comp = new SizeBasedRenditionComparator();
            Collections.sort(renditions, comp);
            Iterator<Rendition> itr = renditions.iterator();
            Rendition bestFit = null;
            while (itr.hasNext()) {
                Rendition rend = itr.next();
                if (!UIHelper.canRenderOnWeb(rend.getMimeType()) || rend.getSize() > sizeinBytes) continue;
                bestFit = rend;
            }
            if (bestFit == null) {
                for (Rendition rend : renditions) {
                    if (!UIHelper.canRenderOnWeb(rend.getMimeType())) continue;
                    bestFit = rend;
                    break;
                }
            } else if (preferOriginal && UIHelper.canRenderOnWeb(asset.getOriginal().getMimeType()) && bestFit.getSize() > asset.getOriginal().getSize()) {
                return asset.getOriginal();
            }
            return bestFit;
        }
        catch (Exception e) {
            log.error("Error occured while getting best fit rendition ", (Throwable)e);
            return null;
        }
    }

    public static boolean canRenderOnWeb(String mimeType) {
        return mimeType != null && (mimeType.toLowerCase().contains("jpeg") || mimeType.toLowerCase().contains("jpg") || mimeType.toLowerCase().contains("gif") || mimeType.toLowerCase().contains("png"));
    }

    public static int getWidth(Rendition r) {
        String name = r.getName();
        int renditionWidth = 0;
        try {
            Asset asset;
            String[] split = name.split("\\.");
            if (split.length > 3) {
                try {
                    renditionWidth = Integer.parseInt(split[2]);
                    return renditionWidth;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((asset = r.adaptTo(Asset.class)) != null && "original".equals(name)) {
                return Integer.parseInt(asset.getMetadataValue("tiff:ImageWidth"));
            }
        }
        catch (Exception e) {
            log.warn("Failed to compute with for rendition " + name, (Throwable)e);
            renditionWidth = 0;
        }
        return renditionWidth;
    }

    public static int getHeight(Rendition r) {
        String name = r.getName();
        int renditionHeight = 0;
        try {
            Asset asset;
            String[] split = name.split("\\.");
            if (split.length > 3) {
                try {
                    renditionHeight = Integer.parseInt(split[3]);
                    return renditionHeight;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if ((asset = r.adaptTo(Asset.class)) != null && "original".equals(name)) {
                return Integer.parseInt(asset.getMetadataValue("tiff:ImageLength"));
            }
        }
        catch (Exception e) {
            log.warn("Failed to compute with for rendition " + name, (Throwable)e);
            renditionHeight = 0;
        }
        return renditionHeight;
    }

    public static String lookupMimeType(String mimeType, Node node, boolean uppercase) {
        try {
            if (node == null || mimeType == null) {
                return null;
            }
            mimeType = mimeType.toUpperCase();
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                int end;
                Node child = it.nextNode();
                String list = child.getProperty("mimetypes").getString();
                if (list == null) continue;
                list = list.replaceAll("\\s", "");
                int ind = (list = list.toUpperCase()).indexOf(mimeType);
                if (ind == -1 || ind != 0 && (ind - 1 < 0 || list.charAt(ind - 1) != ',') || list.charAt(end = ind + mimeType.length()) != ',' && list.charAt(end) != ';') continue;
                if (uppercase) {
                    return child.getProperty("jcr:description").getString();
                }
                return child.getProperty("jcr:title").getString();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    public static boolean isCheckedOutByDrive(Asset asset) {
        try {
            Node assetNode = asset.adaptTo(Node.class);
            Node jcrContent = assetNode.getNode("jcr:content");
            if (jcrContent != null && jcrContent.hasProperty("cq:drivelock")) {
                return true;
            }
        }
        catch (PathNotFoundException e) {
            log.warn("Asset does not exists ", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.warn("Respoitory execption", (Throwable)e);
        }
        return false;
    }

    public static String getCheckedOutby(Asset asset) {
        if (UIHelper.isCheckedOutByDrive(asset)) {
            try {
                Node assetNode = asset.adaptTo(Node.class);
                Node jcrContent = assetNode.getNode("jcr:content");
                return jcrContent.getProperty("cq:drivelock").getString();
            }
            catch (PathNotFoundException e) {
                log.warn("Asset does not exists ", (Throwable)e);
            }
            catch (ValueFormatException e) {
                log.warn("Value format exception ", (Throwable)e);
            }
            catch (RepositoryException e) {
                log.warn("Respoitory execption", (Throwable)e);
            }
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SizeBasedRenditionComparator
    implements Comparator<Rendition> {
        private SizeBasedRenditionComparator() {
        }

        @Override
        public int compare(Rendition r1, Rendition r2) {
            if (r1.getSize() < r2.getSize()) {
                return -1;
            }
            if (r1.getSize() == r2.getSize()) {
                return 0;
            }
            return 1;
        }
    }
}

