/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.metadata.SimpleXmpToJcrMetadataBuilder;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.tagging.JcrTagManagerFactory;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
@Property(name="process.label", value={"Extract Meta Data"})
public class ExtractMetadataProcess
extends AbstractAssetWorkflowProcess {
    private static final String JCR_CONTENT_JCR_DATA = "jcr:content/jcr:data";
    private static final String METADATA_PROPERTY_NAME_ADOBE_KEYWORDS = "lr:hierarchicalSubject";
    @Reference
    private JcrTagManagerFactory tagManagerFactory = null;
    private boolean sha1Enabled = false;
    @Property(boolValue={true})
    public static final String ENABLE_SHA1_GEN = "cq.dam.enable.sha1";
    private static final Logger log = LoggerFactory.getLogger(ExtractMetadataProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block9: {
            try {
                Session session = workflowSession.getSession();
                Asset asset = this.getAssetFromPayload(workItem, session);
                if (null != asset) {
                    asset.setBatchMode(true);
                    AssetHandler handler = this.getAssetHandler(asset.getMimeType());
                    if (null != handler) {
                        Node originalBinary;
                        Resource resource;
                        ResourceResolver resolver;
                        Resource metadataResource;
                        Node assetNode = asset.adaptTo(Node.class);
                        Node content = assetNode.getNode("jcr:content");
                        if (!content.hasProperty("newRendition")) {
                            content.setProperty("newRendition", true);
                        }
                        if (null != (metadataResource = (resolver = (resource = asset.adaptTo(Resource.class)).getResourceResolver()).getResource(resource, "jcr:content/metadata"))) {
                            ModifiableValueMap mvp = metadataResource.adaptTo(ModifiableValueMap.class);
                            mvp.put("writebackEnable", false);
                        }
                        ExtractedMetadata metadata = handler.extractMetadata(asset);
                        metadata.setMetaDataProperty("dam:extracted", Calendar.getInstance().getTime());
                        metadata.setMetaDataProperty("writebackEnable", false);
                        Rendition original = asset.getOriginal();
                        if (this.sha1Enabled) {
                            String sha1 = DigestUtils.shaHex((InputStream)original.getStream());
                            metadata.setMetaDataProperty("dam:sha1", sha1);
                        }
                        if ((originalBinary = original.adaptTo(Node.class)).hasProperty(JCR_CONTENT_JCR_DATA)) {
                            metadata.setMetaDataProperty("dam:size", originalBinary.getProperty(JCR_CONTENT_JCR_DATA).getBinary().getSize());
                        }
                        this.resetMimetype(asset, metadata);
                        this.saveMetadata(asset, metadata);
                        this.extractHierarchicalSubjects(asset, session);
                    } else {
                        log.error("execute: cannot extract metadata, no handler found for asset [{}] with mime type [{}]", (Object)asset.getPath(), (Object)asset.getMimeType());
                    }
                    break block9;
                }
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot extract metadata, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            catch (Exception e) {
                log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected void saveMetadata(Asset asset, ExtractedMetadata metadata) {
        Resource resource = asset.adaptTo(Resource.class);
        ResourceResolver resolver = resource.getResourceResolver();
        Resource metadataResource = resolver.getResource(resource, "jcr:content/metadata");
        if (null != metadataResource) {
            SimpleXmpToJcrMetadataBuilder metadataBuilder = new SimpleXmpToJcrMetadataBuilder();
            try {
                metadataBuilder.storeAsXmp(metadata, asset, false);
            }
            catch (Exception e) {
                log.error("saveMetadata: error while saving metdata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
            }
        } else {
            log.error("execute: cannot save metdata for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }

    private void resetMimetype(Asset asset, ExtractedMetadata metadata) {
        if (this.mimeTypeService.getMimeType(asset.getName()) != null) {
            String mimeType = this.mimeTypeService.getMimeType(asset.getName());
            metadata.setMetaDataProperty("dc:format", mimeType);
        }
    }

    private void extractHierarchicalSubjects(Asset asset, Session session) {
        Resource resource = asset.adaptTo(Resource.class);
        ResourceResolver resolver = resource.getResourceResolver();
        Resource metadataResource = resolver.getResource(resource, "jcr:content/metadata");
        if (null != metadataResource) {
            ValueMap props = metadataResource.adaptTo(ValueMap.class);
            Object[] subjects = props.get(METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, new String[0]);
            log.debug("got hierarchical subjects [{}] with content [{}].", (Object)METADATA_PROPERTY_NAME_ADOBE_KEYWORDS, (Object)StringUtils.join((Object[])subjects, (String)", "));
            if (subjects.length > 0) {
                TagManager tagManager = this.tagManagerFactory.getTagManager(session);
                ArrayList<Tag> tags = new ArrayList<Tag>();
                for (Object subject : subjects) {
                    String titlePath = StringUtils.replaceOnce((String)subject, (String)":|", (String)":");
                    Tag tag = tagManager.resolveByTitle(titlePath = StringUtils.replace((String)titlePath, (String)"|", (String)"/"));
                    if (null != tag) {
                        log.debug("got tag [{}] from title path [{}].", (Object)tag.getTagID(), (Object)titlePath);
                        tags.add(tag);
                        continue;
                    }
                    log.warn("could not find tag from title path [{}].", (Object)titlePath);
                }
                if (tags.size() > 0) {
                    try {
                        log.debug("tagging [{}] with [{}] tags.", (Object)asset.getPath(), (Object)tags.size());
                        tagManager.setTags(metadataResource, tags.toArray(new Tag[tags.size()]), asset.isBatchMode());
                    }
                    catch (Exception e) {
                        log.error("cannot save hierarchical subjects for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
            }
        } else {
            log.error("cannot save hierarchical subjects for asset [{}], doesn't have metdata node.", (Object)asset.getPath());
        }
    }

    @Activate
    protected void Actiate(ComponentContext context) throws RepositoryException {
        this.sha1Enabled = OsgiUtil.toBoolean(context.getProperties().get(ENABLE_SHA1_GEN), true);
    }

    protected void bindTagManagerFactory(JcrTagManagerFactory jcrTagManagerFactory) {
        this.tagManagerFactory = jcrTagManagerFactory;
    }

    protected void unbindTagManagerFactory(JcrTagManagerFactory jcrTagManagerFactory) {
        if (this.tagManagerFactory == jcrTagManagerFactory) {
            this.tagManagerFactory = null;
        }
    }
}

