/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.Externalizer;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.mailer.MessageGatewayService;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.mail.Header;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.tika.io.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Send download asset email notification."}), @Property(name="process.label", value={"Send Download Asset Email Notification"})})
public class SendDownloadAssetEmailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SendDownloadAssetEmailProcess.class);
    private static final String DEFAULT_CHARSET = "utf-8";
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference(policy=ReferencePolicy.STATIC)
    private MessageGatewayService messageGatewayService;

    @Override
    public void execute(WorkItem workItem, WorkflowSession session, MetaDataMap metaData) throws WorkflowException {
        block11: {
            ResourceResolver resolver;
            MetaDataMap workflowMetaDataMap = workItem.getWorkflowData().getMetaDataMap();
            try {
                resolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session.getSession()));
            }
            catch (LoginException e) {
                throw new WorkflowException("could not get resource resolver", e);
            }
            if (this.messageGatewayService != null) {
                try {
                    ArrayList<InternetAddress> emailRecipients = this.getEmailRecipients(workflowMetaDataMap);
                    if (workflowMetaDataMap != null) {
                        String downloadUrl = workflowMetaDataMap.get("downloadUrl").toString();
                        if (emailRecipients != null && emailRecipients.size() != 0 && downloadUrl != null) {
                            String template = this.getEmailTemplate(metaData, session);
                            if (template != null) {
                                HashMap<String, String> valuesMap = new HashMap<String, String>();
                                String hostPrefix = this.getHostPrefix(resolver);
                                valuesMap.put("host.prefix", hostPrefix);
                                valuesMap.put("downloadurl", downloadUrl);
                                valuesMap.put("event.TimeStamp", Calendar.getInstance().getTime().toString());
                                StrSubstitutor substitutor = new StrSubstitutor(valuesMap);
                                HtmlEmail email = this.createEmail(template, substitutor);
                                email.setTo(emailRecipients);
                                this.messageGatewayService.getGateway(HtmlEmail.class).send(email);
                                log.info("Email was sent.");
                            } else {
                                log.warn("Did not send email. No email template defined");
                            }
                        } else {
                            log.warn("Did not send email. No recipient addresses or download URL available.");
                        }
                        break block11;
                    }
                    log.warn("Did not send email. No workflow metadata is null.");
                }
                catch (EmailException e) {
                    e.printStackTrace();
                    log.error("Fatal error while sending email in workflow", (Throwable)e);
                }
            } else {
                log.warn("cannot send email, mail service unavailable. Please configure Gateway in OSGi Console");
            }
        }
    }

    private ArrayList<InternetAddress> getEmailRecipients(MetaDataMap workflowMetaDataMap) {
        ArrayList<InternetAddress> emailRecipients = null;
        String recipients = workflowMetaDataMap.get("emailTo", new String());
        List<String> recipientList = Arrays.asList(recipients.split(","));
        emailRecipients = new ArrayList<InternetAddress>();
        try {
            for (String recipient : recipientList) {
                if (StringUtils.isEmpty((String)recipient)) continue;
                emailRecipients.add(new InternetAddress(recipient));
            }
        }
        catch (AddressException e) {
            log.error("Cannot get the recipient email address: " + e.getMessage());
        }
        return emailRecipients;
    }

    private String getEmailTemplate(MetaDataMap workflowMetaDataMap, WorkflowSession session) {
        String template = (String)((Object)workflowMetaDataMap.get("template", String.class));
        if (template == null) {
            String templatePath = (String)((Object)workflowMetaDataMap.get("templatePath", String.class));
            template = this.loadTemplate(session.getSession(), templatePath);
        }
        log.debug("Loaded template: {}", (Object)template);
        return template;
    }

    private HtmlEmail createEmail(String template, StrSubstitutor substitutor) {
        HtmlEmail email = new HtmlEmail();
        try {
            CountingInputStream in = new CountingInputStream((InputStream)new ByteArrayInputStream(template.getBytes(DEFAULT_CHARSET)));
            InternetHeaders iHdrs = new InternetHeaders((InputStream)in);
            HashMap<String, String[]> hdrs = new HashMap<String, String[]>();
            Enumeration e = iHdrs.getAllHeaders();
            while (e.hasMoreElements()) {
                Header hdr = (Header)e.nextElement();
                String name = hdr.getName();
                log.debug("Header: {} = {}", (Object)name, (Object)hdr.getValue());
                hdrs.put(name, iHdrs.getHeader(name));
            }
            String templateBody = template.substring(in.getCount());
            email.setCharset(DEFAULT_CHARSET);
            String[] ret = (String[])hdrs.remove("subject");
            String subject = ret == null ? "" : ret[0];
            log.info("Email subject: " + subject);
            if (!StringUtils.isEmpty((String)subject)) {
                email.setSubject(substitutor.replace(subject));
            }
            templateBody = substitutor.replace(templateBody);
            log.debug("Substituted mail body: {}", (Object)templateBody);
            email.setMsg(templateBody);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e) {
            log.error("Create email: ", (Object)e.getMessage());
        }
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadTemplate(Session session, String path) {
        InputStream is = null;
        try {
            Node content = session.getNode(path + "/" + "jcr:content");
            is = content.getProperty("jcr:data").getBinary().getStream();
            InputStreamReader r = new InputStreamReader(is, DEFAULT_CHARSET);
            StringWriter w = new StringWriter();
            IOUtils.copy((Reader)r, (Writer)w);
            String string = w.toString();
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        catch (Exception e) {
            log.error("Error while loading mail template {}:{}", (Object)path, (Object)e.toString());
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return null;
    }

    private String getHostPrefix(ResourceResolver resolver) {
        Externalizer externalizer = resolver.adaptTo(Externalizer.class);
        String externalizerHost = externalizer.externalLink(resolver, "local", "");
        if (externalizerHost != null && externalizerHost.endsWith("/")) {
            return externalizerHost.substring(0, externalizerHost.length() - 1);
        }
        return externalizerHost;
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }
}

