/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.mp3;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import de.vdheide.mp3.MP3File;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class Mp3Handler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(Mp3Handler.class);
    public static final String CONTENT_MIMETYPE = "audio/mpeg";
    private static final int MARGIN = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        log.debug("extractMetadata: importing asset [{}]...", (Object)asset.getPath());
        InputStream is = asset.getOriginal().getStream();
        File tmpFile = null;
        try {
            try {
                block13: {
                    FileOutputStream out = null;
                    try {
                        tmpFile = File.createTempFile("__example", ".mp3");
                        out = new FileOutputStream(tmpFile);
                        IOUtils.copy((InputStream)is, (OutputStream)out);
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    IOUtils.closeQuietly((InputStream)is);
                    MP3File mp3File = null;
                    try {
                        mp3File = new MP3File(tmpFile.getAbsolutePath());
                        metadata.setMetaDataProperty("Album", mp3File.getAlbum().getTextContent());
                        metadata.setMetaDataProperty("Artist", mp3File.getArtist().getTextContent());
                        metadata.setMetaDataProperty("BitRate", String.valueOf(mp3File.getBitrate()));
                        metadata.setMetaDataProperty("Comment", mp3File.getComments().getTextContent());
                        metadata.setMetaDataProperty("Composer", mp3File.getComposer().getTextContent());
                        metadata.setMetaDataProperty("CopyrightInfo", mp3File.getCopyrightText().getTextContent());
                        metadata.setMetaDataProperty("EncodedBy", mp3File.getEncodedBy().getTextContent());
                        metadata.setMetaDataProperty("Genre", mp3File.getGenre().getTextContent());
                        metadata.setMetaDataProperty("OriginalArtist", mp3File.getOriginalArtist().getTextContent());
                        metadata.setMetaDataProperty("PlayingTime", mp3File.getTime().getTextContent());
                        String title = mp3File.getTitle().getTextContent();
                        metadata.setMetaDataProperty("Title", title);
                        metadata.setMetaDataProperty("TrackNumber", mp3File.getTrack().getTextContent());
                        metadata.setMetaDataProperty("UserDefinedURL", mp3File.getUserDefinedURL().getTextContent());
                        metadata.setMetaDataProperty("Year", mp3File.getYear().getTextContent());
                        metadata.setMetaDataProperty("Lyricist", mp3File.getLyricist().getTextContent());
                        metadata.setMetaDataProperty("MediaType", mp3File.getMediaType().getTextContent());
                        metadata.setMetaDataProperty("HasCopyRight", String.valueOf(mp3File.getCopyright()));
                        metadata.setMetaDataProperty("SamplerRate", String.valueOf(mp3File.getSamplerate()));
                        metadata.setMetaDataProperty("Length", String.valueOf(mp3File.getLength()));
                        metadata.setMetaDataProperty("MPEG Level", String.valueOf(mp3File.getMPEGLevel()));
                        metadata.setMetaDataProperty("Layer", String.valueOf(mp3File.getLayer()));
                        metadata.setMetaDataProperty("Mode", String.valueOf(mp3File.getMode()));
                        metadata.setMetaDataProperty("Padding", String.valueOf(mp3File.getPadding()));
                        metadata.setMetaDataProperty("Original", String.valueOf(mp3File.getOriginal()));
                        byte[] picture = mp3File.getPicture().getBinaryContent();
                        if (picture != null) {
                            metadata.setProperty("picture", picture);
                        }
                        Object var10_12 = null;
                        if (mp3File == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (mp3File != null) {
                            mp3File.delete();
                        }
                        throw throwable;
                    }
                    mp3File.delete();
                }
                Object var12_15 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
            catch (Exception e) {
                metadata.cleanup();
                log.error("extractMetadata: unable to read MP3 metadata for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                Object var12_16 = null;
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw throwable;
        }
        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    /*
     * Exception decompiling
     */
    public BufferedImage getImage(Rendition rendition) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String[] getMimeTypes() {
        return new String[]{CONTENT_MIMETYPE};
    }
}

