/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.msoffice;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.standard.msoffice.MSOfficeMetadata;
import com.day.cq.dam.handler.standard.msoffice.MetaDataReaderListener;
import com.day.cq.dam.handler.standard.msoffice.wmf.WmfDecoder;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.hpsf.Thumbnail;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(inherit=true, metatype=false)
@Service
public class MSOfficeHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(MSOfficeHandler.class);
    public static final String MIMETYPE_MSWORD = "application/msword";
    public static final String MIMETYPE_MSEXCEL = "application/msexcel";
    public static final String[] MIMETYPES_SUPPORTED = new String[]{"application/msword", "application/msexcel"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        MSOfficeMetadata metadata;
        block4: {
            metadata = new MSOfficeMetadata();
            InputStream is = asset.getOriginal().getStream();
            try {
                try {
                    POIFSReader r = new POIFSReader();
                    MetaDataReaderListener mdrlistener = new MetaDataReaderListener();
                    mdrlistener.setMetadata(metadata);
                    r.registerListener((POIFSReaderListener)mdrlistener);
                    r.read(is);
                }
                catch (Exception e) {
                    log.debug("Failed to extract metadata", (Throwable)e);
                    Object var7_8 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    break block4;
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        byte[] picture = (byte[])this.extractMetadata(rendition.getAsset()).getProperty("picture");
        if (picture != null) {
            try {
                Thumbnail thumbnail = new Thumbnail(picture);
                long cbFormat = thumbnail.getClipboardFormatTag();
                if (cbFormat == (long)Thumbnail.CFTAG_WINDOWS) {
                    return this.getWindowsImage(thumbnail, dim);
                }
                if (cbFormat == (long)Thumbnail.CFTAG_MACINTOSH) {
                    return this.getMacintoshImage(thumbnail, dim);
                }
                log.warn("Unsupported clipboard format {} see http://poi.apache.org/apidocs/org/apache/poi/hpsf/Thumbnail.html", (Object)cbFormat);
            }
            catch (Exception e) {
                log.warn("getImage: error while getting image for MSOffice document [{}]: ", (Object)rendition.getPath(), (Object)e);
            }
        }
        return null;
    }

    public String[] getMimeTypes() {
        return MIMETYPES_SUPPORTED;
    }

    private BufferedImage getWindowsImage(Thumbnail thumbnail, Dimension dim) throws Exception {
        byte[] wmfThumbnail = thumbnail.getThumbnailAsWMF();
        WmfDecoder wdec = new WmfDecoder(wmfThumbnail);
        dim = wdec.getDimension();
        BufferedImage bi = new BufferedImage(dim.width, dim.height, 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(Toolkit.getDefaultToolkit().createImage(wdec), null, null);
        return new Layer(bi).getImage();
    }

    private BufferedImage getMacintoshImage(Thumbnail thumbnail, Dimension dim) throws Exception {
        throw new UnsupportedOperationException("Thumbnail has been created on Macintosh which is not yet implemented");
    }
}

