/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ooxml;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.handler.AssetHandler;
import com.day.cq.dam.api.handler.store.AssetStore;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

@Component(inherit=true, metatype=false)
@Service
public class OpenOfficeHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(OpenOfficeHandler.class);
    public static final String MIMETYPE_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String MIMETYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final String[] MIMETYPES_SUPPORTED = new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};
    private static final String ENTRY_CORE = "docProps/core.xml";
    private static final String ENTRY_APP = "docProps/app.xml";
    private static final String ENTRY_THUMBNAIL = "docProps/thumbnail.jpeg";
    private static final String ENTRY_THUMBNAIL_EMF = "docProps/thumbnail.emf";
    private static final String JPEG_FORMAT = "jpeg";
    @Reference(policy=ReferencePolicy.STATIC)
    protected MimeTypeService mimeTypeService;
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetStore store;
    private static final String META_KEY_THUMBNAIL = "thumbnail";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block4: {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(asset.getOriginal().getStream()));
            metadata = new ExtractedMetadata();
            try {
                try {
                    this.readEntries(zis, metadata, asset);
                }
                catch (Exception e) {
                    log.warn("Failed to extract metadata for {} reason: {}", (Object)asset.getPath(), (Object)e.getMessage());
                    log.debug("Stack Trace: ", (Throwable)e);
                    Object var6_5 = null;
                    IOUtils.closeQuietly((InputStream)zis);
                    break block4;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IOUtils.closeQuietly((InputStream)zis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)zis);
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, null);
    }

    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        Asset asset = rendition.getAsset();
        byte[] picture = (byte[])this.extractMetadata(asset).getProperty(META_KEY_THUMBNAIL);
        if (picture != null) {
            return new Layer((InputStream)new ByteArrayInputStream(picture), dim).getImage();
        }
        log.warn("Failed to retrieve thumbnail for {}", (Object)asset.getPath());
        return null;
    }

    public String[] getMimeTypes() {
        return MIMETYPES_SUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEntries(ZipInputStream zis, ExtractedMetadata metadata, Asset asset) throws Exception {
        ZipEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            Rendition rend;
            ByteArrayOutputStream out;
            String name = entry.getName();
            if (name.equals(ENTRY_CORE) || name.equals(ENTRY_APP)) {
                Element next;
                out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zis, (OutputStream)out);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(out.toByteArray()));
                IOUtils.closeQuietly((OutputStream)out);
                DocumentTraversal dt = (DocumentTraversal)((Object)document);
                NodeIterator nit = dt.createNodeIterator(document, 1, null, true);
                nit.nextNode();
                while ((next = (Element)nit.nextNode()) != null) {
                    metadata.setMetaDataProperty(next.getLocalName(), next.getTextContent());
                }
                continue;
            }
            if (name.equals(ENTRY_THUMBNAIL)) {
                Object var13_12;
                out = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)zis, (OutputStream)out);
                    metadata.setProperty(META_KEY_THUMBNAIL, out.toByteArray());
                    var13_12 = null;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    IOUtils.closeQuietly((OutputStream)out);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                {
                    continue;
                }
            }
            if (!name.equals(ENTRY_THUMBNAIL_EMF)) continue;
            String mimeType = this.mimeTypeService.getMimeType(name);
            AssetHandler handler = this.store.getAssetHandler(mimeType);
            BufferedImage img = handler.getImage(rend = asset.addRendition("thumbnail.emf", (InputStream)zis, mimeType));
            if (img != null) {
                Object var15_13;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)img, JPEG_FORMAT, baos);
                    baos.flush();
                    metadata.setProperty(META_KEY_THUMBNAIL, baos.toByteArray());
                    var15_13 = null;
                }
                catch (Throwable throwable) {
                    var15_13 = null;
                    IOUtils.closeQuietly((OutputStream)baos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)baos);
                {
                    continue;
                }
            }
            log.info("Cannot extract image from EMF format");
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindStore(AssetStore assetStore) {
        this.store = assetStore;
    }

    protected void unbindStore(AssetStore assetStore) {
        if (this.store == assetStore) {
            this.store = null;
        }
    }
}

