/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.pdf;

import com.adobe.granite.asset.api.AssetManager;
import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.InputStreamByteReader;
import com.adobe.internal.io.RandomAccessFileByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomDecodeFilter;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCBaseState;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.PDFApplicationData;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPagePiece;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTreeNode;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptions;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMOptionsBase;
import com.adobe.internal.pdftoolkit.services.manipulations.PMMService;
import com.adobe.internal.pdftoolkit.services.rasterizer.PageRasterizer;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.security.SecurityKeyPassword;
import com.adobe.internal.pdftoolkit.services.xmp.DocumentMetadata;
import com.adobe.internal.pdftoolkit.services.xmp.XMPService;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.AbstractAssetHandler;
import com.day.cq.dam.handler.gibson.fontmanager.FontManagerService;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(inherit=true, metatype=false)
@Service
public class PdfHandler
extends AbstractAssetHandler {
    private static final Logger log = LoggerFactory.getLogger(PdfHandler.class);
    public static final String CONTENT_MIMETYPE = "application/pdf";
    private static final String AI_MIMETYPE = "application/illustrator";
    @Reference
    private FontManagerService fontManagerService;
    private static final ASName k_Illustrator = ASName.create((String)"Illustrator");
    private static final ASName k_AIPrivateData1 = ASName.create((String)"AIPrivateData1");

    private static boolean isAIFile(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPageTree pageTree = pdfDoc.requirePages();
        int numPages = pageTree.size();
        if (numPages > 1) {
            return false;
        }
        PDFPage page = pageTree.getPage(0);
        PDFPagePiece pagePiece = page.getPieceInfo();
        if (pagePiece == null) {
            return false;
        }
        PDFApplicationData appData = pagePiece.getApplicationData(k_Illustrator);
        if (appData == null) {
            return false;
        }
        CosObject cosObj = appData.getPrivateData();
        if (!(cosObj instanceof CosDictionary)) {
            return false;
        }
        CosDictionary privateData = (CosDictionary)cosObj;
        if (privateData.get(k_AIPrivateData1) == null) {
            return false;
        }
        ASString pageLastMod = page.getDictionaryStringValue(ASName.k_LastModified);
        ASString appLastMod = appData.getDictionaryStringValue(ASName.k_LastModified);
        return appLastMod == null || pageLastMod == null || appLastMod.equals(pageLastMod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata;
        block51: {
            Exception e5222;
            PDFDocument pdfDoc;
            InputStreamByteReader byteReader;
            InputStream is;
            block47: {
                metadata = new ExtractedMetadata();
                log.debug("extractMetadata: importing asset [{}]", (Object)asset.getPath());
                is = null;
                byteReader = null;
                pdfDoc = null;
                is = asset.getOriginal().getStream();
                byteReader = new InputStreamByteReader(is);
                pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
                boolean canRead = true;
                if (pdfDoc.isEncrypted()) {
                    try {
                        this.unlock(pdfDoc);
                    }
                    catch (Exception e2) {
                        log.warn("extractMetadata: unable to decrypt document [{}]: ", (Object)asset.getPath(), (Object)e2);
                        canRead = false;
                    }
                }
                if (canRead) {
                    DocumentMetadata pdfMetadata = XMPService.getDocumentMetadata((PDFDocument)pdfDoc);
                    try {
                        Integer numPages = pdfDoc.requirePages().getNumPages();
                        if (numPages != null) {
                            metadata.setMetaDataProperty("numPages", numPages);
                        }
                    }
                    catch (Exception e3) {
                        log.error("extractMetadata: error extracting number of pages in the pdf ", (Object)asset.getPath(), (Object)e3);
                    }
                    if (pdfMetadata.getAuthor() != null) {
                        metadata.setMetaDataProperty("Author", pdfMetadata.getAuthor());
                    }
                    if (pdfMetadata.getCreationDate() != null) {
                        metadata.setMetaDataProperty("CreationDate", pdfMetadata.getCreationDate());
                    }
                    if (pdfMetadata.getModificationDate() != null) {
                        metadata.setMetaDataProperty("ModificationDate", pdfMetadata.getModificationDate());
                    }
                    if (pdfMetadata.getProducer() != null) {
                        metadata.setMetaDataProperty("Producer", pdfMetadata.getProducer());
                    }
                    if (pdfMetadata.getSubject() != null) {
                        metadata.setMetaDataProperty("Subject", pdfMetadata.getSubject());
                    }
                    if (pdfMetadata.getTitle() != null) {
                        metadata.setMetaDataProperty("Title", pdfMetadata.getTitle());
                    }
                    if (pdfMetadata.getTrapped() != null) {
                        metadata.setMetaDataProperty("Trapped", pdfMetadata.getTrapped());
                    }
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        pdfMetadata.exportXMP((OutputStream)out);
                        metadata.setXmp(new ByteArrayInputStream(out.toByteArray()));
                    }
                    catch (Exception e4) {
                        log.error("extractMetadata: cannot import embedded XMP data for document [{}]: ", (Object)asset.getPath(), (Object)e4);
                        log.warn("Failed to set xmp metadata for the asset {}, trying to extract using DefaultFormatHandler", (Object)asset.getPath());
                        this.execGenericProcessor(asset.getOriginal().getStream(), metadata);
                    }
                }
                Object var10_14 = null;
                if (pdfDoc == null) break block47;
                try {
                    pdfDoc.close();
                }
                catch (Exception e5222) {
                    log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e5222);
                }
            }
            if (byteReader != null) {
                try {
                    byteReader.close();
                }
                catch (IOException e5222) {
                    log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e5222);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e5222) {
                    log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e5222);
                }
            }
            break block51;
            {
                catch (IOException e6) {
                    Exception e5222;
                    log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e6);
                    Object var10_15 = null;
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Exception e5222) {
                            log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                    if (byteReader != null) {
                        try {
                            byteReader.close();
                        }
                        catch (IOException e5222) {
                            log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e5222) {
                            log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                    break block51;
                }
                catch (PDFException e7) {
                    Exception e5222;
                    log.warn("extractMetadata: error while extracting metadata from PDF [{}]: ", (Object)asset.getPath(), (Object)e7);
                    Object var10_16 = null;
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Exception e5222) {
                            log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                    if (byteReader != null) {
                        try {
                            byteReader.close();
                        }
                        catch (IOException e5222) {
                            log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e5222) {
                            log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e5222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e5222;
                Object var10_17 = null;
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e5222) {
                        log.debug("extractMetadata: error while closing PDF document [{}]: ", (Object)asset.getPath(), (Object)e5222);
                    }
                }
                if (byteReader != null) {
                    try {
                        byteReader.close();
                    }
                    catch (IOException e5222) {
                        log.debug("extractMetadata: error while closing byteReader [{}]: ", (Object)asset.getPath(), (Object)e5222);
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e5222) {
                        log.debug("extractMetadata: error while closing inputStream [{}]: ", (Object)asset.getPath(), (Object)e5222);
                    }
                }
                throw throwable;
            }
        }
        this.setMimetype(metadata, asset);
        return metadata;
    }

    private void unlock(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFEncryptionType encryptionType = pdfDoc.getEncryptionType();
        if (encryptionType.equals(PDFEncryptionType.Password)) {
            SecurityKeyPassword defaultKey = SecurityKeyPassword.newInstance((PDFDocument)pdfDoc);
            pdfDoc.unlock((SecurityKey)defaultKey);
        }
    }

    public ByteWriter getRAFByteWriter(File file) throws IOException {
        RandomAccessFile raf = this.getRandomAccessFileForWriting(file, true);
        RandomAccessFileByteWriter byteWriter = new RandomAccessFileByteWriter(raf);
        return byteWriter;
    }

    private RandomAccessFile getRandomAccessFileForWriting(File file, boolean create) throws IOException {
        RandomAccessFile raf = null;
        if (create) {
            file.delete();
            if (file.exists()) {
                throw new IOException("Failed to delete pre-existing file: \"" + file.getAbsolutePath() + "\".");
            }
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        raf = new RandomAccessFile(file, "rw");
        return raf;
    }

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        block47: {
            block40: {
                block41: {
                    block48: {
                        subAssets = new ArrayList<String>();
                        if (asset.isSubAsset()) {
                            return subAssets;
                        }
                        is = null;
                        pdfDoc = null;
                        is = asset.getOriginal().getStream();
                        pdfDoc = PdfHandler.parseDocument(is);
                        oldBatchMode = asset.isBatchMode();
                        asset.setBatchMode(true);
                        assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
                        if (!PdfHandler.isAIFile(pdfDoc)) break block48;
                        this.removeSubAssets(asset, assetManager);
                        fontSet = this.fontManagerService.getPdfFontSet();
                        options = new RasterizationOptions();
                        options.setFontSet(fontSet);
                        ocProps = pdfDoc.requireCatalog().getOCProperties();
                        if (ocProps != null) {
                            defaultOCConfig = ocProps.getDefaultOCConfigDict();
                            defaultOCConfig.setBaseState(PDFOCBaseState.OFF);
                            itr = ocProps.getOCGs().iterator();
                            ocg = null;
                            layer = 1;
                            while (itr.hasNext()) {
                                ocg = (PDFOCGroup)itr.next();
                                defaultOCConfig.setONList(PDFOCGroupArray.newInstance((PDFDocument)pdfDoc, (PDFOCGroup)ocg));
                                defaultOCConfig.setOFFList(null);
                                rasterizer = new PageRasterizer((PDFPageTreeNode)pdfDoc.requirePages(), options);
                                while (rasterizer.hasNext()) {
                                    block39: {
                                        itout = null;
                                        imageTmpFile = null;
                                        iis = null;
                                        try {
                                            image = rasterizer.next();
                                            imageTmpFile = File.createTempFile("image", ".tmp");
                                            layerImage = new Layer(image);
                                            fileName = "layer" + layer + ".png";
                                            itout = FileUtils.openOutputStream((File)imageTmpFile);
                                            layerImage.write("image/png", 1.0, itout);
                                            iis = FileUtils.openInputStream((File)imageTmpFile);
                                            subAsset = asset.addSubAsset(fileName, "image/png", iis);
                                            subAssets.add(subAsset.getPath());
                                            var23_36 = null;
                                        }
                                        catch (Throwable var22_37) {
                                            var23_36 = null;
                                            IOUtils.closeQuietly(iis);
                                            IOUtils.closeQuietly(itout);
                                            FileUtils.deleteQuietly((File)imageTmpFile);
                                            throw var22_37;
                                        }
                                        IOUtils.closeQuietly((InputStream)iis);
                                        IOUtils.closeQuietly((OutputStream)itout);
                                        FileUtils.deleteQuietly((File)imageTmpFile);
                                        {
                                            break block39;
                                            catch (Exception e) {
                                                PdfHandler.log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                                                var23_36 = null;
                                                IOUtils.closeQuietly(iis);
                                                IOUtils.closeQuietly(itout);
                                                FileUtils.deleteQuietly((File)imageTmpFile);
                                            }
                                        }
                                    }
                                    ++layer;
                                }
                            }
                        }
                        ** GOTO lbl175
                    }
                    pages = pdfDoc.requirePages();
                    this.removeSubAssets(asset, assetManager);
                    if (pages != null) break block40;
                    options = Collections.emptyList();
                    var28_38 = null;
                    if (pdfDoc == null) break block41;
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e) {
                        PdfHandler.log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
                return options;
            }
            try {
                iter = pdfDoc.requirePages().iterator();
                pmmService = new PMMService(pdfDoc);
                i = 0;
                while (iter.hasNext()) {
                    block44: {
                        block42: {
                            document = pmmService.extractPages((PDFPage)iter.next(), 1, PMMOptions.newInstance((PMMOptionsBase)PMMOptions.AllOptions), PDFOpenOptions.newInstance());
                            fileName = "page" + (i + 1) + ".pdf";
                            tmpFile = null;
                            fis = null;
                            byteWriter = null;
                            tmpFile = File.createTempFile(fileName, ".pdf");
                            byteWriter = this.getRAFByteWriter(tmpFile);
                            document.save(byteWriter, (PDFSaveOptions)PDFSaveFullOptions.newInstance());
                            fis = new FileInputStream(tmpFile);
                            subAsset = asset.addSubAsset(fileName, "application/pdf", fis);
                            subAssets.add(subAsset.getPath());
                            var25_46 = null;
                            if (document == null) break block42;
                            try {
                                document.close();
                            }
                            catch (Exception e) {
                                PdfHandler.log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e);
                            }
                        }
                        if (byteWriter != null) {
                            try {
                                byteWriter.close();
                            }
                            catch (IOException e) {
                                PdfHandler.log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e);
                            }
                        }
                        IOUtils.closeQuietly((InputStream)fis);
                        FileUtils.deleteQuietly((File)tmpFile);
                        {
                            break block44;
                            catch (Exception e) {
                                PdfHandler.log.warn("createSubAsset: error while creating subasset [" + (i + 1) + "] for [{}]: ", (Object)asset.getPath(), (Object)e);
                                var25_46 = null;
                                if (document != null) {
                                    try {
                                        document.close();
                                    }
                                    catch (Exception e) {
                                        PdfHandler.log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e);
                                    }
                                }
                                if (byteWriter != null) {
                                    try {
                                        byteWriter.close();
                                    }
                                    catch (IOException e) {
                                        PdfHandler.log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e);
                                    }
                                }
                                IOUtils.closeQuietly((InputStream)fis);
                                FileUtils.deleteQuietly((File)tmpFile);
                            }
                        }
                        catch (Throwable var24_48) {
                            var25_46 = null;
                            if (document != null) {
                                try {
                                    document.close();
                                }
                                catch (Exception e) {
                                    PdfHandler.log.warn("processSubAssets: error while closing subAsset document [{}]: ", (Object)asset.getPath(), (Object)e);
                                }
                            }
                            if (byteWriter != null) {
                                try {
                                    byteWriter.close();
                                }
                                catch (IOException e) {
                                    PdfHandler.log.warn("processSubAssets: error while closing byteWriter [{}]: ", (Object)asset.getPath(), (Object)e);
                                }
                            }
                            IOUtils.closeQuietly(fis);
                            FileUtils.deleteQuietly((File)tmpFile);
                            throw var24_48;
                        }
                    }
                    ++i;
                }
lbl175:
                // 2 sources

                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
                var28_39 = null;
                ** if (pdfDoc == null) goto lbl-1000
            }
            catch (Throwable var27_49) {
                var28_41 = null;
                if (pdfDoc != null) {
                    try {
                        pdfDoc.close();
                    }
                    catch (Exception e) {
                        PdfHandler.log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                    }
                }
                throw var27_49;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    pdfDoc.close();
                }
                catch (Exception e) {
                    PdfHandler.log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block47;
                catch (Exception e) {
                    PdfHandler.log.warn("processSubAssets: error while creating sub assets for asset [{}]: ", (Object)asset.getPath(), (Object)e);
                    var28_40 = null;
                    if (pdfDoc != null) {
                        try {
                            pdfDoc.close();
                        }
                        catch (Exception e) {
                            PdfHandler.log.warn("processSubAssets: error while closing parent pdf document [{}]: ", (Object)asset.getPath(), (Object)e);
                        }
                    }
                }
            }
        }
        return subAssets;
    }

    private void removeSubAssets(Asset asset, AssetManager assetManager) {
        Collection<Asset> subAssets = asset.getSubAssets();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{CONTENT_MIMETYPE, AI_MIMETYPE};
    }

    @Override
    public BufferedImage getImage(Rendition rendition) throws IOException {
        return this.getImage(rendition, (Dimension)null);
    }

    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        RasterizationOptions rasterizationOptions = null;
        try {
            rasterizationOptions = new RasterizationOptions();
        }
        catch (Throwable e) {
            log.warn("getImage: unable to create rasterization option: ", (Object)rendition.getPath(), (Object)e);
            throw new IOException(e.getMessage());
        }
        try {
            PDFFontSet fontSet = null;
            fontSet = this.fontManagerService.getPdfFontSet();
            rasterizationOptions.setFontSet(fontSet);
        }
        catch (Exception e) {
            log.warn("exception: fontmanagerserviceimpl with [{}]", (Object)e.getMessage());
        }
        rasterizationOptions.ignoreErrors(true);
        try {
            return this.getImage(rendition, rasterizationOptions);
        }
        catch (Exception e) {
            log.warn("getImage: unable to generate image : ", (Object)rendition.getPath(), (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(Rendition rendition, RasterizationOptions rasterizationOptions) throws Exception {
        BufferedImage image;
        InputStreamByteReader byteReader;
        block13: {
            PageRasterizer rasterizer;
            PDFDocument pdfDoc;
            block12: {
                byteReader = null;
                pdfDoc = null;
                image = null;
                try {
                    byteReader = new InputStreamByteReader(rendition.getStream());
                    PDFOpenOptions openOptions = PDFOpenOptions.newInstance();
                    ArrayList<JPXDecodeFilter> filters = new ArrayList<JPXDecodeFilter>();
                    filters.add(new JPXDecodeFilter());
                    openOptions.registerCustomFilters(filters);
                    pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)openOptions);
                    if (!pdfDoc.isEncrypted()) break block12;
                    try {
                        this.unlock(pdfDoc);
                    }
                    catch (Exception e) {
                        log.warn("getImage: unable to decrypt document [{}]: ", (Object)rendition.getPath(), (Object)e);
                        BufferedImage bufferedImage = null;
                        Object var12_12 = null;
                        if (pdfDoc != null) {
                            pdfDoc.close();
                        }
                        if (byteReader != null) {
                            byteReader.close();
                        }
                        return bufferedImage;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    if (pdfDoc != null) {
                        pdfDoc.close();
                    }
                    if (byteReader != null) {
                        byteReader.close();
                    }
                    throw throwable;
                }
            }
            PDFPageTree pages = pdfDoc.requirePages();
            if (pages == null) {
                image = null;
            }
            if ((rasterizer = new PageRasterizer((PDFPageTreeNode)pages, rasterizationOptions)).hasNext() && (image = rasterizer.next()) != null) {
                Layer layer = new Layer(image);
                image = layer.getImage();
            }
            Object var12_13 = null;
            if (pdfDoc == null) break block13;
            pdfDoc.close();
        }
        if (byteReader != null) {
            byteReader.close();
        }
        return image;
    }

    private static PDFDocument parseDocument(InputStream input) throws IOException, PDFException {
        InputStreamByteReader byteReader = null;
        PDFDocument pdfDoc = null;
        byteReader = new InputStreamByteReader(input);
        try {
            pdfDoc = PDFDocument.newInstance((ByteReader)byteReader, (PDFOpenOptions)PDFOpenOptions.newInstance());
        }
        catch (PDFException e) {
            log.warn("extractMetadata: error while reading PDF [{}]: ", (Throwable)e);
            throw e;
        }
        return pdfDoc;
    }

    protected void bindFontManagerService(FontManagerService fontManagerService) {
        this.fontManagerService = fontManagerService;
    }

    protected void unbindFontManagerService(FontManagerService fontManagerService) {
        if (this.fontManagerService == fontManagerService) {
            this.fontManagerService = null;
        }
    }

    private static class JPXDecodeFilter
    implements CustomDecodeFilter {
        private JPXDecodeFilter() {
        }

        public ASName getName() {
            return ASName.k_JPXDecode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream decode(InputStream is, FilterParams filterParams) throws CustomFilterException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                BufferedImage bufImage = ImageIO.read(is);
                if (bufImage != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((DataBufferByte)bufImage.getData().getDataBuffer()).getData());
                    return byteArrayInputStream;
                }
                InputStream inputStream = null;
                return inputStream;
            }
            catch (IOException e) {
                log.error("Error decoding the JPX: ", (Object)e.getMessage(), (Object)e);
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.error("Error closing the stream: ", (Object)e.getMessage(), (Object)e);
                }
            }
            return null;
        }
    }
}

