/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.api.model;

import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.utils.Scene7AssetUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Scene7AssetImpl
implements Scene7Asset {
    private static final long serialVersionUID = 5536087022446822682L;
    private Map<Object, Object> assetAttributes;

    public Scene7AssetImpl(Map<Object, Object> assetAttributes) {
        this.assetAttributes = assetAttributes != null ? assetAttributes : new HashMap<Object, Object>();
        this.assetAttributes.put((Object)Scene7AssetProperty.SUB_ASSETS, new ArrayList());
    }

    public Scene7AssetImpl(Scene7Asset scene7Asset, Map<Object, Object> overrideProperties) {
        Map<Object, Object> originalPropertyMap = this.getPropertiesMap(scene7Asset);
        if (overrideProperties != null) {
            originalPropertyMap.putAll(overrideProperties);
        }
        this.assetAttributes = originalPropertyMap;
    }

    @Override
    public Scene7AssetType getAssetType() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.SCENE7_ASSET_TYPE, Scene7AssetType.class);
    }

    @Override
    public String getAssetTypeStr() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.ASSET_TYPE_STRING, String.class);
    }

    @Override
    public String getName() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.NAME, String.class);
    }

    @Override
    public String getAssetHandle() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.ASSET_HANDLE, String.class);
    }

    @Override
    public String getFileName() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.FILE_NAME, String.class);
    }

    @Override
    public String getFolder() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.FOLDER, String.class);
    }

    @Override
    public String getFolderHandle() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.FOLDER_HANDLE, String.class);
    }

    @Override
    public String getCreatedBy() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.CREATED_BY, String.class);
    }

    @Override
    public String getModifiedBy() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.MODIFIED_BY, String.class);
    }

    @Override
    public Date getCreatedDate() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.CREATED_DATE, Date.class);
    }

    @Override
    public Date getModifiedDate() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.MODIFIED_DATE, Date.class);
    }

    @Override
    public String getOriginalFile() {
        return this.getAssetProperties().get("originalFile");
    }

    @Override
    public String getOriginalPath() {
        return this.getAssetProperties().get("originalPath");
    }

    @Override
    public List<Scene7Asset> getSubAssets() {
        List subAssets = this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.SUB_ASSETS, List.class);
        if (subAssets != null) {
            subAssets = Collections.unmodifiableList(subAssets);
        }
        return subAssets;
    }

    @Override
    public Scene7Asset getOriginatorAsset() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.ORIGINATOR, Scene7Asset.class);
    }

    @Override
    public void updateOriginatorAsset(Scene7Asset originator) {
        this.assetAttributes.put((Object)Scene7AssetProperty.ORIGINATOR, originator);
    }

    @Override
    public void addSubAsset(Scene7Asset subAsset) {
        List subAssets = this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.SUB_ASSETS, List.class);
        if (subAssets != null) {
            subAssets.add(subAsset);
        }
    }

    @Override
    public Long getWidth() {
        return (Long)this.assetAttributes.get((Object)Scene7AssetProperty.WIDTH);
    }

    @Override
    public Long getHeight() {
        return (Long)this.assetAttributes.get((Object)Scene7AssetProperty.HEIGHT);
    }

    @Override
    public String getUrlModifier() {
        return this.getAssetProperties().get("urlModifier");
    }

    @Override
    public Map<String, String> getViewerPresetConfigurationSettings() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, Map.class);
    }

    @Override
    public String getViewerPresetType() {
        return this.getAssetProperties().get("type");
    }

    @Override
    public String getRootFolder() {
        int idx;
        String folder = this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.FOLDER, String.class);
        if (folder != null && (idx = folder.indexOf("/")) > -1) {
            String root = folder.substring(0, idx + 1);
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            return root;
        }
        return "";
    }

    @Override
    public boolean isPublished() {
        return Boolean.parseBoolean(this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.READY_TO_PUBLISH, String.class));
    }

    @Override
    public Integer getFileSize() {
        return Scene7AssetUtils.parseInt((String)this.getAssetProperties().get("fileSize"));
    }

    @Override
    public String getVideoEncodingPresetId() {
        return this.getProperty(this.assetAttributes, (Object)Scene7AssetProperty.VIDEO_ENCODING_PRESET_ID, String.class);
    }

    private <T> T getProperty(Map<?, ?> map, Object key, Class<T> convertTo) {
        Object propValue = map.get(key);
        T convertedPropValue = null;
        if (propValue != null && convertTo.isAssignableFrom(propValue.getClass())) {
            convertedPropValue = convertTo.cast(propValue);
        }
        return convertedPropValue;
    }

    private Map<Object, Object> getPropertiesMap(Scene7Asset scene7Asset) {
        HashMap<Object, Object> propertiesMap = new HashMap<Object, Object>();
        propertiesMap.put((Object)Scene7AssetProperty.ASSET_TYPE_STRING, scene7Asset.getAssetTypeStr());
        propertiesMap.put((Object)Scene7AssetProperty.SCENE7_ASSET_TYPE, (Object)scene7Asset.getAssetType());
        propertiesMap.put((Object)Scene7AssetProperty.ASSET_HANDLE, scene7Asset.getAssetHandle());
        propertiesMap.put((Object)Scene7AssetProperty.NAME, scene7Asset.getName());
        propertiesMap.put((Object)Scene7AssetProperty.FILE_NAME, scene7Asset.getFileName());
        propertiesMap.put((Object)Scene7AssetProperty.FOLDER, scene7Asset.getFolder());
        propertiesMap.put((Object)Scene7AssetProperty.FOLDER_HANDLE, scene7Asset.getFolderHandle());
        propertiesMap.put((Object)Scene7AssetProperty.CREATED_BY, scene7Asset.getCreatedBy());
        propertiesMap.put((Object)Scene7AssetProperty.MODIFIED_BY, scene7Asset.getModifiedBy());
        propertiesMap.put((Object)Scene7AssetProperty.VIDEO_ENCODING_PRESET_ID, scene7Asset.getVideoEncodingPresetId());
        propertiesMap.put((Object)Scene7AssetProperty.CREATED_DATE, scene7Asset.getCreatedDate());
        propertiesMap.put((Object)Scene7AssetProperty.MODIFIED_DATE, scene7Asset.getModifiedDate());
        propertiesMap.put((Object)Scene7AssetProperty.ORIGINAL_FILE, scene7Asset.getOriginalFile());
        propertiesMap.put((Object)Scene7AssetProperty.ORIGINAL_PATH, scene7Asset.getOriginalPath());
        propertiesMap.put((Object)Scene7AssetProperty.WIDTH, scene7Asset.getWidth());
        propertiesMap.put((Object)Scene7AssetProperty.HEIGHT, scene7Asset.getHeight());
        propertiesMap.put((Object)Scene7AssetProperty.URL_MODIFIER, scene7Asset.getUrlModifier());
        propertiesMap.put((Object)Scene7AssetProperty.READY_TO_PUBLISH, scene7Asset.isPublished());
        propertiesMap.put((Object)Scene7AssetProperty.FILE_SIZE, scene7Asset.getFileSize());
        propertiesMap.put((Object)Scene7AssetProperty.VIEWER_PRESET_TYPE, scene7Asset.getViewerPresetType());
        propertiesMap.put((Object)Scene7AssetProperty.VIEWER_PRESET_CONFIGURATION_SETTINGS, scene7Asset.getViewerPresetConfigurationSettings());
        propertiesMap.put((Object)Scene7AssetProperty.SUB_ASSETS, scene7Asset.getSubAssets());
        propertiesMap.put((Object)Scene7AssetProperty.ORIGINATOR, scene7Asset.getOriginatorAsset());
        propertiesMap.put((Object)Scene7AssetProperty.ASSET_PROPERTIES, scene7Asset.getAssetProperties());
        return propertiesMap;
    }

    @Override
    public Map<String, String> getAssetProperties() {
        return (Map)this.assetAttributes.get((Object)Scene7AssetProperty.ASSET_PROPERTIES);
    }

    public static enum Scene7AssetProperty {
        ASSET_TYPE_STRING,
        SCENE7_ASSET_TYPE,
        ASSET_HANDLE,
        NAME,
        FILE_NAME,
        FOLDER,
        FOLDER_HANDLE,
        CREATED_BY,
        MODIFIED_BY,
        VIDEO_ENCODING_PRESET_ID,
        CREATED_DATE,
        MODIFIED_DATE,
        ORIGINAL_FILE,
        ORIGINAL_PATH,
        WIDTH,
        HEIGHT,
        URL_MODIFIER,
        READY_TO_PUBLISH,
        FILE_SIZE,
        VIEWER_PRESET_TYPE,
        VIEWER_PRESET_CONFIGURATION_SETTINGS,
        SUB_ASSETS,
        ORIGINATOR,
        ASSET_PROPERTIES;

    }
}

