/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video.servlet;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.handler.ffmpeg.FfmpegNotFoundException;
import com.day.cq.dam.video.servlet.VideoProfileListServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.selectors", value={"videoclip"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Servlet to clip video."})})
public class VideoClipServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(VideoProfileListServlet.class);
    private File workingDir;
    @Reference(policy=ReferencePolicy.STATIC)
    protected ExecutableLocator locator;
    @Property(value={"./logs/ffmpeg"})
    public static final String PROP_WORKING_DIR = "ffmpeg.workingdir";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block30: {
            Resource resource = request.getResource();
            Asset asset = null;
            if (null != resource) {
                asset = resource.adaptTo(Asset.class);
            }
            String startTime = request.getParameter("startTime");
            String endTime = request.getParameter("endTime");
            FFMpegWrapper wrapper = null;
            File tmpWorkingDir = null;
            File tmpDir = null;
            FileOutputStream fos = null;
            InputStream is = null;
            tmpDir = File.createTempFile("cqdam", null);
            tmpDir.delete();
            tmpDir.mkdir();
            tmpWorkingDir = this.createTempDir(this.getWorkingDir());
            File tmpFile = new File(tmpDir, asset.getName().replace(' ', '_'));
            fos = new FileOutputStream(tmpFile);
            is = asset.getOriginal().getStream();
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            wrapper = new FFMpegWrapper(tmpFile, tmpWorkingDir);
            wrapper.setExecutableLocator(this.locator);
            File clippedFile = wrapper.getClip(Double.parseDouble(startTime), Double.parseDouble(endTime), asset.getMimeType());
            FileInputStream fis = new FileInputStream(clippedFile);
            String roundStartTime = startTime.substring(0, startTime.indexOf("."));
            String roundEndTime = endTime.substring(0, endTime.indexOf("."));
            String mimeType = asset.getMimeType();
            String outputFormat = mimeType.substring(mimeType.indexOf("/") + 1);
            asset.addRendition("cq5dam.clipped." + roundStartTime + "." + roundEndTime + "." + outputFormat, (InputStream)fis, asset.getMimeType());
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)fos);
            try {
                if (tmpDir != null) {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
            }
            catch (IOException e) {
                this.log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
            }
            try {
                if (tmpWorkingDir != null) {
                    FileUtils.deleteDirectory((File)tmpWorkingDir);
                }
                break block30;
            }
            catch (IOException e) {
                this.log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            }
            break block30;
            catch (IOException e) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(fos);
                try {
                    if (tmpDir != null) {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                }
                catch (IOException e2) {
                    this.log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
                }
                try {
                    if (tmpWorkingDir != null) {
                        FileUtils.deleteDirectory((File)tmpWorkingDir);
                    }
                    break block30;
                }
                catch (IOException e3) {
                    this.log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
                }
                break block30;
            }
            catch (FfmpegNotFoundException e2) {
                this.log.error(e2.getMessage(), (Throwable)e2);
                break block30;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(fos);
                try {
                    if (tmpDir != null) {
                        FileUtils.deleteDirectory((File)tmpDir);
                    }
                }
                catch (IOException e) {
                    this.log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
                }
                try {
                    if (tmpWorkingDir != null) {
                        FileUtils.deleteDirectory((File)tmpWorkingDir);
                    }
                }
                catch (IOException e) {
                    this.log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
                }
            }
        }
    }

    public File getWorkingDir() {
        this.workingDir.mkdir();
        return this.workingDir;
    }

    private File resolveWorkingDir(String slingHome, String path) {
        File workingDir;
        if (path == null) {
            path = "";
        }
        if (!(workingDir = new File(path = path.replace('/', File.separatorChar))).isAbsolute()) {
            File baseDir = new File(slingHome == null ? "" : slingHome).getAbsoluteFile();
            workingDir = new File(baseDir, path).getAbsoluteFile();
        }
        try {
            this.log.info("ffmpeg working directory: {}", (Object)workingDir.getCanonicalPath());
        }
        catch (IOException e) {
            this.log.info("ffmpeg working directory: {}", (Object)workingDir.getAbsolutePath());
        }
        return workingDir;
    }

    protected void activate(ComponentContext ctx) {
        String slingHome = ctx.getBundleContext().getProperty("sling.home");
        this.workingDir = this.resolveWorkingDir(slingHome, (String)ctx.getProperties().get(PROP_WORKING_DIR));
    }

    protected File createTempDir(File parentDir) {
        File tempDir = null;
        try {
            tempDir = File.createTempFile("cqdam", null, parentDir);
            tempDir.delete();
            tempDir.mkdir();
        }
        catch (IOException e) {
            this.log.warn("could not create temp directory in the [{}] with the exception", (Object)parentDir, (Object)e);
        }
        return tempDir;
    }

    protected void bindLocator(ExecutableLocator executableLocator) {
        this.locator = executableLocator;
    }

    protected void unbindLocator(ExecutableLocator executableLocator) {
        if (this.locator == executableLocator) {
            this.locator = null;
        }
    }
}

