/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video.servlet;

import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.handler.ffmpeg.FfmpegNotFoundException;
import com.day.cq.dam.video.VideoProfile;
import com.day.cq.dam.video.servlet.VideoTestResult;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/video/profile"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"transcode.test"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Test a video profile."})})
public class VideoTestServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private static final String NN_TEST = "test";
    private static final String PROPERTY_INPUT_FILE_NAME = "inputName";
    private static final String PROPERTY_OUTPUT_FILE_NAME = "outputName";
    private static final String PROPERTY_INPUT_DURATION = "inputDuration";
    private static final String PROPERTY_INPUT_SIZE = "inputSize";
    private static final String PROPERTY_TEST_LOG = "log";
    private static final String PROPERTY_TEST_SUCCESS = "success";
    private static final String PROPERTY_TEST_LAST_RUN = "lastRun";
    private static final String NODE_INPUT_FILE = "input";
    private static final String NODE_OUTPUT_FILE = "output";
    private static final String TMP_DIR = "videotest";
    private final Logger log = LoggerFactory.getLogger(VideoTestServlet.class);
    @Reference(policy=ReferencePolicy.STATIC)
    protected ExecutableLocator locator;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        File tmpDir = null;
        try {
            tmpDir = File.createTempFile(TMP_DIR, null);
            tmpDir.delete();
            tmpDir.mkdir();
            VideoProfile videoProfile = new VideoProfile(request.getResource());
            Node testNode = this.getTestNode(videoProfile);
            VideoTestResult testResult = this.runTest(videoProfile, testNode, tmpDir);
            this.storeTestResult(testNode, testResult);
            this.writeTestResult(response, testResult);
        }
        catch (JSONException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (tmpDir != null) {
                try {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
                catch (IOException e) {
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTestResult(Node testNode, VideoTestResult testResult) throws RepositoryException, FileNotFoundException {
        if (testResult.getOutput() != null) {
            FileInputStream resultIs = null;
            try {
                resultIs = new FileInputStream(testResult.getOutput());
                JcrUtils.putFile(testNode, NODE_OUTPUT_FILE, testResult.getOutputMimeType(), resultIs);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resultIs);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)resultIs);
        }
        if (testResult.getOutputName() != null) {
            testNode.setProperty(PROPERTY_OUTPUT_FILE_NAME, testResult.getOutputName());
        }
        if (testResult.getInputDuration() > 0.0) {
            testNode.setProperty(PROPERTY_INPUT_DURATION, testResult.getInputDuration());
        }
        if (testResult.getInputSize() != null) {
            testNode.setProperty(PROPERTY_INPUT_SIZE, this.formatInputSize(testResult.getInputSize()));
        }
        if (testResult.getFfmpegLog() != null) {
            testNode.setProperty(PROPERTY_TEST_LOG, testResult.getFfmpegLog());
        }
        testNode.setProperty(PROPERTY_TEST_SUCCESS, testResult.isSuccess());
        testNode.setProperty(PROPERTY_TEST_LAST_RUN, Calendar.getInstance());
        testNode.getSession().save();
    }

    private String formatInputSize(Dimension inputSize) {
        if (inputSize != null) {
            return inputSize.width + ":" + inputSize.height;
        }
        return "";
    }

    private void writeTestResult(SlingHttpServletResponse response, VideoTestResult testResult) throws IOException, JSONException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter(response.getWriter());
        writer.object();
        writer.key(PROPERTY_INPUT_SIZE).value(this.formatInputSize(testResult.getInputSize()));
        writer.key(PROPERTY_INPUT_DURATION).value(testResult.getInputDuration());
        writer.key(PROPERTY_OUTPUT_FILE_NAME).value(testResult.getOutputName());
        writer.key(PROPERTY_TEST_SUCCESS).value(testResult.isSuccess());
        writer.key(PROPERTY_TEST_LOG).value(testResult.getFfmpegLog());
        writer.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoTestResult runTest(VideoProfile videoProfile, Node testNode, File tmpDir) {
        VideoTestResult result;
        block12: {
            result = new VideoTestResult();
            try {
                String testVideoName = testNode.getProperty(PROPERTY_INPUT_FILE_NAME).getString();
                javax.jcr.Property testVideoData = testNode.getProperty("input/jcr:content/jcr:data");
                Binary binary = null;
                InputStream is = null;
                FFMpegWrapper wrapper = null;
                FileOutputStream fos = null;
                try {
                    binary = testVideoData.getBinary();
                    is = binary.getStream();
                    File tmpFile = new File(tmpDir, testVideoName);
                    fos = new FileOutputStream(tmpFile);
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    wrapper = FFMpegWrapper.fromProfile(tmpFile, videoProfile, tmpDir);
                    wrapper.setExecutableLocator(this.locator);
                    File video = wrapper.transcode();
                    result.setOutput(video);
                    result.setOutputName(video.getName());
                    result.setOutputMimeType(wrapper.getOutputMimetype());
                    result.setInputDuration(wrapper.getInputDuration());
                    result.setInputSize(wrapper.getInputSize());
                    result.setFfmpegLog(wrapper.getFFMpegOutput().toString());
                    result.setSuccess(true);
                }
                catch (IOException e) {
                    block13: {
                        try {
                            this.log.error(e.getMessage(), (Throwable)e);
                            if (wrapper == null) break block13;
                            result.setFfmpegLog(wrapper.getFFMpegOutput().toString());
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            IOUtils.closeQuietly(fos);
                            if (binary != null) {
                                binary.dispose();
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(fos);
                    if (binary != null) {
                        binary.dispose();
                    }
                    break block12;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)fos);
                if (binary != null) {
                    binary.dispose();
                }
            }
            catch (FfmpegNotFoundException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result.setFfmpegLog("Error transcoding: " + e.getMessage());
            }
            catch (ValueFormatException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result.setFfmpegLog("Error transcoding: " + e.getMessage());
            }
            catch (PathNotFoundException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result.setFfmpegLog("Error transcoding: " + e.getMessage());
            }
            catch (RepositoryException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                result.setFfmpegLog("Error transcoding: " + e.getMessage());
            }
        }
        return result;
    }

    private Node getTestNode(VideoProfile videoProfile) throws RepositoryException {
        Node profileNode = videoProfile.getContentNode();
        if (profileNode.hasNode(NN_TEST)) {
            return profileNode.getNode(NN_TEST);
        }
        return profileNode.addNode(NN_TEST);
    }

    protected void bindLocator(ExecutableLocator executableLocator) {
        this.locator = executableLocator;
    }

    protected void unbindLocator(ExecutableLocator executableLocator) {
        if (this.locator == executableLocator) {
            this.locator = null;
        }
    }
}

