/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.image.Font;
import com.day.image.Layer;
import com.day.image.LineStyle;
import java.awt.Color;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Axis {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_INVERT = 1;
    public static final int TYPE_LOG = 2;
    public static final int TYPE_LOGINV = 3;
    public static final int TYPE_CATEG = 4;
    public static final int TYPE_CATEGINV = 5;
    public static final int NO_AXIS = 48;
    public static final int X_AXIS = 120;
    public static final int Y_AXIS = 121;
    public static final int U_AXIS = 117;
    public static final int V_AXIS = 118;
    public static final int LABEL_ABOVE = 0;
    public static final int LABEL_BELOW = 1;
    public static final int LABEL_RIGHT = 0;
    public static final int LABEL_LEFT = 16;
    public static final int LABEL_CENTER = 32;
    public static final int LABEL_TYPE_NUMBER = 0;
    public static final int LABEL_TYPE_DATE = 1;
    public static final int TITLE_POS_NONE = 0;
    public static final int TITLE_POS_ABOVE = 1;
    public static final int TITLE_POS_BELOW = 2;
    public static final int TITLE_POS_BOTH = 3;
    int width;
    int height;
    LineStyle style;
    int tickfrom;
    int tickto;
    int tickdistance;
    int numticks;
    LineStyle tickstyle;
    int subtickfrom;
    int subtickto;
    int subtickspertick;
    LineStyle subtickstyle;
    Font labelfont;
    Color labelcolor;
    int labeldx;
    int labeldy;
    int labelalign;
    int labelcs;
    int labelwidth;
    private String labelformat;
    private String sublabelformat;
    int labeltype;
    private double rangemin;
    private double rangemax;
    private double rangestep;
    private double rangescale;
    private double rangeoffset;
    private boolean rangeminset;
    private boolean rangemaxset;
    private boolean rangestepset;
    private boolean rangescaleset;
    private boolean rangeoffsetset;
    int rangetype;
    int titlepos;
    double inflate = 1.0;
    int[] tickpos = new int[256];
    double[] ticksample = new double[256];
    private AxisDrawer axisDrawer;
    private int axisType;

    private Axis(Graph graph, int axisType) {
        this.setType(axisType);
    }

    public static Axis getInstance(Graph graph, int type) throws IllegalArgumentException {
        return new Axis(graph, type);
    }

    public static Axis getInstance(Graph graph) {
        return new Axis(graph, 48);
    }

    public Layer draw(Graph graph, boolean doDraw) {
        return this.axisDrawer != null ? this.axisDrawer.draw(graph, doDraw) : null;
    }

    static String formatlabel(int type, String format, String label) {
        if (label == null) {
            label = "";
        }
        if (type == 0) {
            return String.format(format, label);
        }
        if (type == 1) {
            try {
                SimpleDateFormat fmt = new SimpleDateFormat();
                Date date = fmt.parse(label);
                return String.format(format, date);
            }
            catch (ParseException pe) {
                return "";
            }
        }
        return "";
    }

    public double getRangemin() {
        return this.rangemin;
    }

    public void setRangemin(double rangemin) {
        if (!this.rangeminset && rangemin != 0.0) {
            this.rangemin = rangemin;
            this.rangeminset = true;
        }
    }

    public double getRangemax() {
        return this.rangemax;
    }

    public void setRangemax(double rangemax) {
        if (!this.rangemaxset && rangemax != 0.0) {
            this.rangemax = rangemax;
            this.rangemaxset = true;
        }
    }

    public double getRangestep() {
        return this.rangestep;
    }

    public void setRangestep(double rangestep) {
        if (!this.rangestepset && rangestep != 0.0) {
            this.rangestep = rangestep;
            this.rangestepset = true;
        }
    }

    public double getRangescale() {
        return this.rangescale;
    }

    public void setRangescale(double rangescale) {
        if (!this.rangescaleset && rangescale != 0.0) {
            this.rangescale = rangescale;
            this.rangescaleset = true;
        }
    }

    public double getRangeoffset() {
        return this.rangeoffset;
    }

    public void setRangeoffset(double rangeoffset) {
        if (!this.rangeoffsetset && rangeoffset != 0.0) {
            this.rangeoffset = rangeoffset;
            this.rangeoffsetset = true;
        }
    }

    public String getLabelformat() {
        return this.labelformat;
    }

    public void setLabelformat(String labelformat) {
        if (labelformat != null && labelformat.length() != 0) {
            this.labelformat = labelformat;
        }
    }

    public String getSublabelformat() {
        return this.sublabelformat;
    }

    public void setSublabelformat(String sublabelformat) {
        if (sublabelformat != null && sublabelformat.length() != 0) {
            this.sublabelformat = sublabelformat;
        }
    }

    public void setType(int type) throws IllegalArgumentException {
        if (type == 120) {
            this.axisDrawer = new XAxis();
        } else if (type == 121) {
            this.axisDrawer = new YAxis();
        } else if (type == 117) {
            this.axisDrawer = new UAxis();
        } else if (type == 118) {
            this.axisDrawer = new VAxis();
        } else if (type == 48) {
            this.axisDrawer = null;
        } else {
            throw new IllegalArgumentException("Unknown type " + (char)type);
        }
        this.axisType = type;
    }

    public int getType() {
        return this.axisType;
    }

    public void setStyle(LineStyle style) {
        this.style = style;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTickfrom(int tickfrom) {
        this.tickfrom = tickfrom;
    }

    public void setTickto(int tickto) {
        this.tickto = tickto;
    }

    public void setTickdistance(int tickdistance) {
        this.tickdistance = tickdistance;
    }

    public void setNumticks(int numticks) {
        this.numticks = numticks;
    }

    public void setTickstyle(LineStyle tickstyle) {
        this.tickstyle = tickstyle;
    }

    public void setSubtickfrom(int subtickfrom) {
        this.subtickfrom = subtickfrom;
    }

    public void setSubtickto(int subtickto) {
        this.subtickto = subtickto;
    }

    public void setSubtickspertick(int subtickspertick) {
        this.subtickspertick = subtickspertick;
    }

    public void setSubtickstyle(LineStyle subtickstyle) {
        this.subtickstyle = subtickstyle;
    }

    public void setLabelfont(Font labelfont) {
        this.labelfont = labelfont;
    }

    public void setLabelcolor(Color labelcolor) {
        this.labelcolor = labelcolor;
    }

    public void setLabeldx(int labeldx) {
        this.labeldx = labeldx;
    }

    public void setLabeldy(int labeldy) {
        this.labeldy = labeldy;
    }

    public void setLabelalign(int labelalign) {
        this.labelalign = labelalign;
    }

    public void setLabelcs(int labelcs) {
        this.labelcs = labelcs;
    }

    public void setLabelwidth(int labelwidth) {
        this.labelwidth = labelwidth;
    }

    public void setLabeltype(int labeltype) {
        this.labeltype = labeltype;
    }

    public void setRangetype(int rangetype) {
        this.rangetype = rangetype;
    }

    public void setTitlepos(int titlepos) {
        this.titlepos = titlepos;
    }

    public void setInflate(double inflate) {
        if (!Double.isNaN(inflate) && inflate != 0.0) {
            this.inflate = inflate;
        }
    }

    public double getTickSample(int i) {
        if (i >= 0 && i < this.numticks) {
            return this.ticksample[i];
        }
        return Double.NaN;
    }

    public int getNumticks() {
        return this.numticks;
    }

    private class UAxis
    implements AxisDrawer {
        private UAxis() {
        }

        public Layer draw(Graph graph, boolean doDraw) {
            int ypos;
            double scale;
            int tw = Axis.this.tickto - Axis.this.tickfrom;
            int stw = Axis.this.subtickto - Axis.this.subtickfrom;
            int spt = Axis.this.subtickspertick;
            int w = Axis.this.width;
            int h = Axis.this.height;
            int lastx = 0;
            Layer l = graph.createLayer(doDraw, w, h);
            int labelnum = 0;
            if (Axis.this.getRangescale() == 0.0) {
                scale = (double)w / (1.0 + Axis.this.getRangemax() - Axis.this.getRangemin());
                Axis.this.setRangescale(scale);
            } else {
                scale = Axis.this.getRangescale();
            }
            int n = ypos = stw > tw ? stw / 2 : tw / 2;
            if (doDraw) {
                l.setLineStyle(Axis.this.style);
                l.drawLine(0.0f, ypos, w - 1, ypos);
            }
            int tc = spt;
            double pos = Axis.this.getRangemin();
            labelnum = (int)pos;
            while ((double)labelnum <= Axis.this.getRangemax()) {
                int x = (int)((pos + Axis.this.getRangeoffset()) * scale);
                if (tc == spt) {
                    if (tw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.tickstyle);
                        l.drawLine(x, ypos - Axis.this.tickfrom, x, ypos - Axis.this.tickto);
                    }
                    if (Axis.this.labelfont != null && x + Axis.this.labeldx >= lastx) {
                        int rl = x + Axis.this.labeldx;
                        int rt = ypos - Axis.this.tickfrom - Axis.this.labeldy;
                        String tmp = Axis.formatlabel(graph.getXAxis().labeltype, graph.getXAxis().labelformat, graph.getData().labels[labelnum]);
                        int flags = 65536;
                        if (Axis.this.labelalign == 32) {
                            flags |= 0x10;
                            rl -= Axis.this.labelwidth / 2;
                        }
                        if (doDraw) {
                            Axis.this.labelfont.drawText(l, rl, rt, Axis.this.labelwidth, 0, tmp, Axis.this.labelcolor, null, flags, Axis.this.labelcs, 0);
                            lastx = rl + Axis.this.labelwidth;
                        }
                    }
                    labelnum += (int)Axis.this.getRangestep();
                    tc = 0;
                } else {
                    if (stw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.subtickstyle);
                        l.drawLine(x, ypos - Axis.this.subtickfrom, x, ypos - Axis.this.subtickto);
                    }
                    ++tc;
                }
                pos += Axis.this.getRangestep() / (double)(spt + 1);
            }
            if (doDraw) {
                l.setX(0);
                l.setY(-ypos - 1);
            }
            return l;
        }
    }

    private final class VAxis
    implements AxisDrawer {
        private VAxis() {
        }

        public Layer draw(Graph graph, boolean doDraw) {
            int tw = Axis.this.tickto - Axis.this.tickfrom;
            int stw = Axis.this.subtickto - Axis.this.subtickfrom;
            int spt = Axis.this.subtickspertick;
            int w = Axis.this.width;
            int h = Axis.this.height;
            Layer l = graph.createLayer(doDraw, w, h);
            int labelnum = 0;
            if (doDraw) {
                double scale;
                if (Axis.this.getRangescale() == 0.0) {
                    scale = (double)h / (1.0 + Axis.this.getRangemax() - Axis.this.getRangemin());
                    Axis.this.setRangescale(scale);
                } else {
                    scale = Axis.this.getRangescale();
                }
                int xpos = w - 1 - (Axis.this.subtickto > Axis.this.tickto ? Axis.this.subtickto : Axis.this.tickto);
                if (doDraw) {
                    int y1 = 0;
                    int y2 = h - 1;
                    if ((graph.getYAxis().titlepos & 1) == 1) {
                        y1 += (int)scale;
                    }
                    if ((graph.getYAxis().titlepos & 2) == 2) {
                        y2 -= (int)scale;
                    }
                    l.setLineStyle(Axis.this.style);
                    l.drawLine(xpos, y1, xpos, y2);
                }
                int tc = spt;
                double pos = Axis.this.getRangemin();
                labelnum = (int)pos;
                while ((double)labelnum <= Axis.this.getRangemax()) {
                    int y = (int)((pos + Axis.this.getRangeoffset()) * scale);
                    if (tc == spt) {
                        if (labelnum >= 0) {
                            Axis.this.tickpos[labelnum] = y;
                        }
                        if (Axis.this.labelfont != null) {
                            int vflags = 2;
                            int hflags = 32;
                            int ll = 0;
                            int lr = xpos + Axis.this.labeldx;
                            int lt = 0;
                            int lb = y + Axis.this.labeldy;
                            if ((Axis.this.labelalign & 1) != 0) {
                                vflags = 0;
                                lt = y + Axis.this.labeldy;
                                lb = 0;
                            } else if ((Axis.this.labelalign & 0x20) != 0) {
                                vflags = 1;
                                lt = y + Axis.this.labeldy;
                                lb = 0;
                            }
                            if ((Axis.this.labelalign & 0x10) != 0) {
                                hflags = 0;
                                lr = ll = xpos + Axis.this.labeldx;
                            }
                            int flags = vflags | hflags | 0x10000;
                            String str = (double)labelnum == Axis.this.getRangemin() && (graph.getYAxis().titlepos & 1) != 0 || (double)labelnum == Axis.this.getRangemax() && (graph.getYAxis().titlepos & 2) != 0 ? (graph.getData().labels[0] != null ? graph.getData().labels[0] : "none") : String.format(Axis.this.labelformat, graph.getData().datarows[labelnum].label);
                            str = str.trim();
                            if (doDraw) {
                                Axis.this.labelfont.drawText(l, ll, lt, lr - ll, lt - lb, str, Axis.this.labelcolor, null, flags, Axis.this.labelcs, 0);
                            }
                        }
                        if (tw != 0 && doDraw && ((double)labelnum != Axis.this.getRangemin() || (graph.getYAxis().titlepos & 1) == 0)) {
                            l.setLineStyle(Axis.this.tickstyle);
                            l.drawLine(xpos + Axis.this.tickfrom, y, xpos + Axis.this.tickto, y);
                        }
                        ++labelnum;
                        tc = 0;
                    } else if (stw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.subtickstyle);
                        l.drawLine(xpos + Axis.this.subtickfrom, y, xpos + Axis.this.subtickto, y);
                        ++tc;
                    }
                    pos += Axis.this.getRangestep() / (double)(spt + 1);
                }
                if (doDraw) {
                    l.setX(-xpos);
                    l.setY(-h);
                    if ((graph.getYAxis().titlepos & 2) != 0) {
                        l.setY(l.getY() + (int)scale - 1);
                    }
                }
            }
            return l;
        }
    }

    private final class YAxis
    implements AxisDrawer {
        private YAxis() {
        }

        public Layer draw(Graph graph, boolean doDraw) {
            int tw = Axis.this.tickto - Axis.this.tickfrom;
            int stw = Axis.this.subtickto - Axis.this.subtickfrom;
            int spt = Axis.this.subtickspertick;
            int w = Axis.this.width;
            int h = Axis.this.height;
            Layer l = graph.createLayer(doDraw, w, h);
            double scale = Axis.this.getRangescale();
            int xpos = w - 1 - (Axis.this.subtickto > Axis.this.tickto ? Axis.this.subtickto : Axis.this.tickto);
            if (doDraw) {
                l.setLineStyle(Axis.this.style);
                l.drawLine(xpos, 0.0f, xpos, h - 1);
            }
            int tc = spt;
            double pos = Axis.this.getRangemin();
            int num = 0;
            while (num <= Axis.this.numticks) {
                int y = h - 1 - (int)((pos + Axis.this.getRangeoffset()) * scale);
                if (tc == spt) {
                    Axis.this.tickpos[num] = y;
                    Axis.this.ticksample[num] = pos;
                    if (Axis.this.labelfont != null && doDraw) {
                        int lh;
                        int ly;
                        int flags;
                        if (Axis.this.labelalign == 0) {
                            flags = 65570;
                            ly = y + Axis.this.labeldy;
                            lh = 0;
                        } else if (Axis.this.labelalign == 32) {
                            flags = 65569;
                            ly = y + Axis.this.labeldy;
                            lh = 0;
                        } else {
                            flags = 65568;
                            ly = y + Axis.this.labeldy;
                            lh = 0;
                        }
                        int lw = -Axis.this.labeldx;
                        String str = String.format(Axis.this.labelformat, new Double(pos));
                        Axis.this.labelfont.drawText(l, 0, ly, lw, lh, str, Axis.this.labelcolor, null, flags, Axis.this.labelcs, 0);
                    }
                    if (tw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.tickstyle);
                        l.drawLine(xpos + Axis.this.tickfrom, y, xpos + Axis.this.tickto, y);
                    }
                    tc = 0;
                    ++num;
                } else {
                    if (stw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.subtickstyle);
                        l.drawLine(xpos + Axis.this.subtickfrom, y, xpos + Axis.this.subtickto, y);
                    }
                    ++tc;
                }
                pos += Axis.this.getRangestep() / (double)(spt + 1);
            }
            if (doDraw) {
                l.setX(-xpos);
                l.setY(-h);
            }
            return l;
        }
    }

    private final class XAxis
    implements AxisDrawer {
        private XAxis() {
        }

        public Layer draw(Graph graph, boolean doDraw) {
            int ypos;
            int tw = Axis.this.tickto - Axis.this.tickfrom;
            int stw = Axis.this.subtickto - Axis.this.subtickfrom;
            int spt = Axis.this.subtickspertick;
            int w = Axis.this.width;
            int h = Axis.this.height;
            Layer l = graph.createLayer(doDraw, w, h);
            double scale = Axis.this.getRangescale();
            int n = ypos = Axis.this.subtickto > Axis.this.tickto ? Axis.this.subtickto : Axis.this.tickto;
            if (doDraw) {
                l.setLineStyle(Axis.this.style);
                l.drawLine(0.0f, ypos, w - 1, ypos);
            }
            int tc = spt;
            double pos = Axis.this.getRangemin();
            int num = 0;
            while (num <= Axis.this.numticks) {
                int x = (int)((pos + Axis.this.getRangeoffset()) * scale);
                if (tc == spt) {
                    if (tw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.tickstyle);
                        l.drawLine(x, ypos - Axis.this.tickfrom, x, ypos - Axis.this.tickto);
                    }
                    Axis.this.tickpos[num] = x;
                    if (Axis.this.labelfont != null && doDraw) {
                        int rl = x + Axis.this.labeldx;
                        int rt = ypos - Axis.this.tickfrom - Axis.this.labeldy;
                        String tmp = String.format(Axis.this.labelformat, new Double(pos));
                        int flags = 65536;
                        if (Axis.this.labelalign == 32) {
                            flags |= 0x10;
                            rl -= Axis.this.labelwidth / 2;
                        }
                        Axis.this.labelfont.drawText(l, rl, rt, Axis.this.labelwidth, 0, tmp, Axis.this.labelcolor, null, flags, Axis.this.labelcs, 0);
                    }
                    tc = 0;
                    ++num;
                } else {
                    if (stw != 0 && doDraw) {
                        l.setLineStyle(Axis.this.subtickstyle);
                        l.drawLine(x, ypos - Axis.this.subtickfrom, x, ypos - Axis.this.subtickto);
                    }
                    ++tc;
                }
                pos += Axis.this.getRangestep() / (double)(spt + 1);
            }
            if (doDraw) {
                l.setX(1);
                l.setY(-ypos - 1);
            }
            return l;
        }
    }

    private static interface AxisDrawer {
        public Layer draw(Graph var1, boolean var2);
    }
}

