/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.BarChart;
import com.day.cq.graphics.chart.LineChart;
import com.day.cq.graphics.chart.PieChart;
import com.day.image.Layer;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Chart {
    private static final Logger log = LoggerFactory.getLogger(Chart.class);
    public static final HashMap<String, Class<?>> chartTypes = new HashMap();
    Rectangle position;

    protected static synchronized void registerChartType(Class<?> chartClass) {
        try {
            if (chartClass.getSuperclass() == Chart.class) {
                Method getNameMethod = chartClass.getMethod("getName", new Class[0]);
                String typeName = getNameMethod.invoke(null, new Object[0]).toString().toLowerCase();
                chartTypes.put(typeName, chartClass);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InvocationTargetException ite) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (Exception e) {
            log.warn("registerChartType: Cannot register {0}: {1}", (Object)chartClass.getName(), (Object)e.toString());
        }
    }

    public static String getName() {
        throw new IllegalStateException("getName must be overwritten by subclass");
    }

    protected Chart() {
    }

    public static Chart getInstance(String typeName) throws NoSuchElementException {
        Class<?> chartClass = chartTypes.get(typeName.toLowerCase());
        if (chartClass == null) {
            log.warn("getInstance: Unknown chart type " + typeName);
            throw new NoSuchElementException("Unknown chart type " + typeName);
        }
        try {
            return (Chart)chartClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new NoSuchElementException("Cannot instantiate a chart: " + ie.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchElementException("Cannot instantiate a chart: " + iae.getMessage());
        }
    }

    public abstract Layer draw(Graph var1, boolean var2);

    static {
        Chart.registerChartType(LineChart.class);
        Chart.registerChartType(BarChart.class);
        Chart.registerChartType(PieChart.class);
    }
}

