/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.jobs.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DailyTimeInterval {
    private final int startMinuteInDay;
    private final int endMinuteInDay;
    private final String stringRepresentation;
    private static final int MIN_PER_HOUR = 60;

    public DailyTimeInterval(int startHour, int startMinute, int endHour, int endMinute) {
        this.startMinuteInDay = startHour * 60 + startMinute;
        this.endMinuteInDay = endHour * 60 + endMinute;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":");
        sb.append(startHour);
        sb.append(":");
        sb.append(startMinute);
        sb.append("-");
        sb.append(endHour);
        sb.append(":");
        sb.append(endMinute);
        this.stringRepresentation = sb.toString();
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public boolean isInInterval(Calendar c) {
        int cMinute = c.get(11) * 60 + c.get(12);
        return cMinute >= this.startMinuteInDay && cMinute <= this.endMinuteInDay;
    }

    public static DailyTimeInterval parse(String str) throws ParseException {
        String[] fromTo = str.split("-");
        if (fromTo.length != 2) {
            throw new ParseException(str, "Missing - separator");
        }
        int[] values = new int[4];
        int valueIndex = 0;
        for (int i = 0; i < 2; ++i) {
            String[] hourMin = fromTo[i].split(":");
            values[valueIndex++] = DailyTimeInterval.parseInt(hourMin[0]);
            values[valueIndex++] = hourMin.length > 1 ? DailyTimeInterval.parseInt(hourMin[1]) : 0;
        }
        return new DailyTimeInterval(values[0], values[1], values[2], values[3]);
    }

    public static List<DailyTimeInterval> parseList(String str) throws ParseException {
        ArrayList<DailyTimeInterval> result = new ArrayList<DailyTimeInterval>();
        if (str != null) {
            String[] items;
            for (String item : items = str.split(",")) {
                if ((item = item.trim()).length() <= 0) continue;
                result.add(DailyTimeInterval.parse(item));
            }
        }
        return result;
    }

    private static int parseInt(String str) throws ParseException {
        int result = 0;
        try {
            result = Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(str, "Invalid integer value");
        }
        return result;
    }

    public static class ParseException
    extends Exception {
        ParseException(String input, String reason) {
            super("Invalid item '" + input + "': " + reason);
        }
    }
}

